/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import io.micronaut.data.connection.reactive.DefaultReactiveConnectionStatus;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public abstract class AbstractReactorConnectionOperations<C>
implements ReactorConnectionOperations<C> {
    protected abstract @NonNull Publisher<C> openConnection(@NonNull ConnectionDefinition var1);

    protected abstract @NonNull Publisher<Void> closeConnection(@NonNull C var1, @NonNull ConnectionDefinition var2);

    @Override
    public boolean managesConnection(ConnectionStatus<C> connectionStatus) {
        if (connectionStatus instanceof DefaultReactiveConnectionStatus) {
            DefaultReactiveConnectionStatus reactiveConnectionStatus = (DefaultReactiveConnectionStatus)connectionStatus;
            return reactiveConnectionStatus.isConnectionOf(this);
        }
        return false;
    }

    @Override
    public final Optional<ConnectionStatus<C>> findConnectionStatus(@NonNull ContextView contextView) {
        return ReactorPropagation.findAllContextElements((ContextView)contextView, ConnectionStatus.class).filter(e -> this.managesConnection((ConnectionStatus<C>)e)).map(status -> status).findFirst();
    }

    @Override
    public <T> @NonNull Flux<T> withConnectionFlux(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, Flux<T>> callback) {
        Objects.requireNonNull(callback, "Callback cannot be null");
        return Flux.deferContextual(contextView -> {
            C connection = this.findConnection((ContextView)contextView);
            if (connection != null) {
                return switch (definition.getPropagationBehavior()) {
                    default -> throw new MatchException(null, null);
                    case ConnectionDefinition.Propagation.REQUIRED, ConnectionDefinition.Propagation.MANDATORY -> this.existingConnectionFlux(definition, callback, connection);
                    case ConnectionDefinition.Propagation.REQUIRES_NEW -> this.openConnectionFlux(definition, callback);
                };
            }
            switch (definition.getPropagationBehavior()) {
                default: {
                    throw new MatchException(null, null);
                }
                case REQUIRED: 
                case REQUIRES_NEW: {
                    break;
                }
                case MANDATORY: {
                    throw this.noConnectionFound();
                }
            }
            return this.openConnectionFlux(definition, callback);
        });
    }

    private <T> Flux<T> existingConnectionFlux(ConnectionDefinition definition, Function<ConnectionStatus<C>, Flux<T>> callback, C clientSession) {
        return this.applyCallbackFlux(callback, new DefaultReactiveConnectionStatus<C>(clientSession, definition, this, false));
    }

    private <T> Flux<T> openConnectionFlux(ConnectionDefinition definition, Function<ConnectionStatus<C>, Flux<T>> callback) {
        return Flux.usingWhen((Publisher)Mono.from(this.openConnection(definition)).map(connection -> new DefaultReactiveConnectionStatus<Object>(connection, definition, this, true)), connectionStatus -> this.applyCallbackFlux(callback, (DefaultReactiveConnectionStatus<C>)connectionStatus).contextWrite(ctx -> this.addClientSession((Context)ctx, (ConnectionStatus<C>)connectionStatus)), connectionStatus -> connectionStatus.onComplete(() -> this.closeConnection(connectionStatus.getConnection(), definition)), (connectionStatus, throwable) -> connectionStatus.onError((Throwable)throwable, () -> this.closeConnection(connectionStatus.getConnection(), definition)), connectionStatus -> connectionStatus.onCancel(() -> this.closeConnection(connectionStatus.getConnection(), definition)));
    }

    @Override
    public <T> @NonNull Mono<T> withConnectionMono(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, Mono<T>> callback) {
        Objects.requireNonNull(callback, "Callback cannot be null");
        return Mono.deferContextual(contextView -> {
            C connection = this.findConnection((ContextView)contextView);
            if (connection != null) {
                return switch (definition.getPropagationBehavior()) {
                    default -> throw new MatchException(null, null);
                    case ConnectionDefinition.Propagation.REQUIRED, ConnectionDefinition.Propagation.MANDATORY -> this.existingConnectionMono(definition, callback, connection);
                    case ConnectionDefinition.Propagation.REQUIRES_NEW -> this.openConnectionMono(definition, callback);
                };
            }
            switch (definition.getPropagationBehavior()) {
                default: {
                    throw new MatchException(null, null);
                }
                case REQUIRED: 
                case REQUIRES_NEW: {
                    break;
                }
                case MANDATORY: {
                    throw this.noConnectionFound();
                }
            }
            return this.openConnectionMono(definition, callback);
        });
    }

    private <T> Mono<T> existingConnectionMono(ConnectionDefinition definition, Function<ConnectionStatus<C>, Mono<T>> callback, C clientSession) {
        return this.applyCallbackMono(callback, new DefaultReactiveConnectionStatus<C>(clientSession, definition, this, false));
    }

    private <T> Mono<T> openConnectionMono(ConnectionDefinition definition, Function<ConnectionStatus<C>, Mono<T>> callback) {
        return Mono.usingWhen((Publisher)Mono.from(this.openConnection(definition)).map(connection -> new DefaultReactiveConnectionStatus<Object>(connection, definition, this, true)), connectionStatus -> this.applyCallbackMono(callback, (DefaultReactiveConnectionStatus<C>)connectionStatus).contextWrite(ctx -> this.addClientSession((Context)ctx, (ConnectionStatus<C>)connectionStatus)), connectionStatus -> connectionStatus.onComplete(() -> this.closeConnection(connectionStatus.getConnection(), definition)), (connectionStatus, throwable) -> connectionStatus.onError((Throwable)throwable, () -> this.closeConnection(connectionStatus.getConnection(), definition)), connectionStatus -> connectionStatus.onCancel(() -> this.closeConnection(connectionStatus.getConnection(), definition)));
    }

    private NoConnectionException noConnectionFound() {
        return new NoConnectionException("No existing connection found for connection marked with propagation 'mandatory'");
    }

    private @NonNull Context addClientSession(@NonNull Context context, @NonNull ConnectionStatus<C> status) {
        return ReactorPropagation.addContextElement((Context)context, status);
    }

    private @Nullable C findConnection(@NonNull ContextView contextView) {
        return this.findConnectionStatus(contextView).map(ConnectionStatus::getConnection).orElse(null);
    }

    private <T> Flux<T> applyCallbackFlux(Function<ConnectionStatus<C>, Flux<T>> callback, DefaultReactiveConnectionStatus<C> connectionStatus) {
        try {
            return callback.apply(connectionStatus);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private <T> Mono<T> applyCallbackMono(Function<ConnectionStatus<C>, Mono<T>> callback, DefaultReactiveConnectionStatus<C> connectionStatus) {
        try {
            return callback.apply(connectionStatus);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }
}

