/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.reactive;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionSynchronization;
import io.micronaut.data.connection.reactive.ReactiveConnectionStatus;
import io.micronaut.data.connection.reactive.ReactiveConnectionSynchronization;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
public final class DefaultReactiveConnectionStatus<C>
implements ReactiveConnectionStatus<C> {
    private static final Mono<Void> EMPTY = Mono.empty();
    private final C connection;
    private final ConnectionDefinition definition;
    private final ReactorConnectionOperations<C> connectionOperations;
    private final boolean isNew;
    private List<ReactiveConnectionSynchronization> connectionSynchronizations;

    public DefaultReactiveConnectionStatus(C connection, ConnectionDefinition definition, ReactorConnectionOperations<C> connectionOperations, boolean isNew) {
        this.connection = connection;
        this.definition = definition;
        this.connectionOperations = connectionOperations;
        this.isNew = isNew;
    }

    public boolean isConnectionOf(ReactorConnectionOperations<C> connectionOperations) {
        return this.connectionOperations == connectionOperations;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public C getConnection() {
        return this.connection;
    }

    @Override
    public ConnectionDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void registerSynchronization(final ConnectionSynchronization synchronization) {
        this.registerReactiveSynchronization(new ReactiveConnectionSynchronization(){

            @Override
            public Publisher<Void> onComplete() {
                return Mono.defer(() -> {
                    synchronization.executionComplete();
                    return Mono.empty();
                });
            }

            @Override
            public Publisher<Void> onClose() {
                return Mono.defer(() -> {
                    synchronization.beforeClosed();
                    return Mono.empty();
                });
            }

            @Override
            public Publisher<Void> afterClose() {
                return Mono.defer(() -> {
                    synchronization.afterClosed();
                    return Mono.empty();
                });
            }
        });
    }

    @Override
    public void registerReactiveSynchronization(ReactiveConnectionSynchronization synchronization) {
        if (this.connectionSynchronizations == null) {
            this.connectionSynchronizations = new ArrayList<ReactiveConnectionSynchronization>(5);
        }
        OrderUtil.sort(this.connectionSynchronizations);
        this.connectionSynchronizations.add(synchronization);
    }

    private Publisher<Void> forEachSynchronizations(Function<ReactiveConnectionSynchronization, Publisher<Void>> consumer) {
        if (this.connectionSynchronizations == null) {
            return Mono.empty();
        }
        Mono chain = Mono.empty();
        ListIterator<ReactiveConnectionSynchronization> listIterator = this.connectionSynchronizations.listIterator(this.connectionSynchronizations.size());
        while (listIterator.hasPrevious()) {
            Publisher<Void> next = consumer.apply(listIterator.previous());
            if (next == EMPTY) continue;
            chain = chain.then(Mono.from(next));
        }
        return chain;
    }

    public Publisher<Void> onComplete(Supplier<Publisher<Void>> closeConnection) {
        return DefaultReactiveConnectionStatus.finallyBlock(this.onComplete(), null, throwable -> this.finallyComplete((Throwable)throwable, closeConnection));
    }

    public Publisher<Void> onError(Throwable outterThrowable, Supplier<Publisher<Void>> closeConnection) {
        return DefaultReactiveConnectionStatus.finallyBlock(this.onError(outterThrowable), outterThrowable, throwable -> this.finallyComplete((Throwable)throwable, closeConnection));
    }

    public Publisher<Void> onCancel(Supplier<Publisher<Void>> closeConnection) {
        return DefaultReactiveConnectionStatus.finallyBlock(this.onCancel(), null, throwable -> this.finallyComplete((Throwable)throwable, closeConnection));
    }

    private Mono<Void> finallyComplete(@Nullable Throwable outterThrowable, Supplier<Publisher<Void>> closeConnection) {
        return DefaultReactiveConnectionStatus.finallyBlock(this.beforeClosed(), outterThrowable, throwable -> this.finallyBeforeClosed((Throwable)throwable, closeConnection));
    }

    private Mono<Void> finallyBeforeClosed(@Nullable Throwable outterThrowable, Supplier<Publisher<Void>> closeConnection) {
        return DefaultReactiveConnectionStatus.finallyBlock(closeConnection.get(), outterThrowable, this::finallyClose);
    }

    private Mono<Void> finallyClose(@Nullable Throwable outterThrowable) {
        Mono next = this.isNew ? Mono.from(this.afterClosed()) : Mono.empty();
        if (outterThrowable != null) {
            next = next.then(Mono.error((Throwable)outterThrowable));
        }
        return next;
    }

    private static Mono<Void> finallyBlock(Publisher<Void> resource, @Nullable Throwable outterThrowable, Function<@Nullable Throwable, Mono<Void>> doFinally) {
        return Mono.from(resource).map(ignore -> Optional.empty()).onErrorResume(throwable -> Mono.just(Optional.of(throwable))).switchIfEmpty(Mono.just(Optional.empty())).flatMap(optionalThrowable -> {
            Throwable throwable = optionalThrowable.orElse(null);
            if (throwable != null) {
                if (outterThrowable != null) {
                    throwable.addSuppressed(outterThrowable);
                }
                return ((Mono)doFinally.apply(throwable)).then(Mono.error((Throwable)throwable));
            }
            return (Mono)doFinally.apply(null);
        });
    }

    private Publisher<Void> onComplete() {
        return this.forEachSynchronizations(ReactiveConnectionSynchronization::onComplete);
    }

    private Publisher<Void> onError(Throwable throwable) {
        return this.forEachSynchronizations(reactiveConnectionSynchronization -> reactiveConnectionSynchronization.onError(throwable));
    }

    private Publisher<Void> onCancel() {
        return this.forEachSynchronizations(ReactiveConnectionSynchronization::onCancel);
    }

    private Publisher<Void> beforeClosed() {
        if (this.isNew) {
            return this.forEachSynchronizations(ReactiveConnectionSynchronization::onClose);
        }
        return Mono.empty();
    }

    private Publisher<Void> afterClosed() {
        if (this.isNew) {
            return this.forEachSynchronizations(ReactiveConnectionSynchronization::afterClose);
        }
        return Mono.empty();
    }
}

