/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionOperationsRegistry;
import io.micronaut.data.connection.DefaultConnectionDefinition;
import io.micronaut.data.connection.annotation.Connectable;
import io.micronaut.data.connection.async.AsyncConnectionOperations;
import io.micronaut.data.connection.interceptor.ConnectionDataSourceTenantResolver;
import io.micronaut.data.connection.reactive.ReactiveStreamsConnectionOperations;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
@Singleton
@InterceptorBean(value={Connectable.class})
public final class ConnectableInterceptor
implements MethodInterceptor<Object, Object> {
    private final Map<TenantExecutableMethod, ConnectionInvocation> connectionInvocationMap = new ConcurrentHashMap<TenantExecutableMethod, ConnectionInvocation>(30);
    private final @NonNull ConnectionOperationsRegistry connectionOperationsRegistry;
    private final @Nullable ConnectionDataSourceTenantResolver tenantResolver;
    private final ConversionService conversionService;

    ConnectableInterceptor(@NonNull ConnectionOperationsRegistry connectionOperationsRegistry, @Nullable ConnectionDataSourceTenantResolver tenantResolver, ConversionService conversionService) {
        this.connectionOperationsRegistry = connectionOperationsRegistry;
        this.tenantResolver = tenantResolver;
        this.conversionService = conversionService;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition() - 10;
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        String tenantDataSourceName = this.tenantResolver != null ? this.tenantResolver.resolveTenantDataSourceName() : null;
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            ExecutableMethod executableMethod = context.getExecutableMethod();
            ConnectionInvocation connectionInvocation = this.connectionInvocationMap.computeIfAbsent(new TenantExecutableMethod(tenantDataSourceName, executableMethod), ignore -> {
                String dataSource = tenantDataSourceName == null ? (String)executableMethod.stringValue(Connectable.class).orElse(null) : tenantDataSourceName;
                ConnectionDefinition connectionDefinition = ConnectableInterceptor.getConnectionDefinition((ExecutableMethod<Object, Object>)executableMethod);
                switch (interceptedMethod.resultType()) {
                    case PUBLISHER: {
                        ReactiveStreamsConnectionOperations operations = this.connectionOperationsRegistry.provideReactive(ReactiveStreamsConnectionOperations.class, dataSource);
                        return new ConnectionInvocation(null, operations, null, connectionDefinition);
                    }
                    case COMPLETION_STAGE: {
                        AsyncConnectionOperations operations = this.connectionOperationsRegistry.provideAsync(AsyncConnectionOperations.class, dataSource);
                        return new ConnectionInvocation(null, null, operations, connectionDefinition);
                    }
                }
                ConnectionOperations operations = this.connectionOperationsRegistry.provideSynchronous(ConnectionOperations.class, dataSource);
                return new ConnectionInvocation(operations, null, null, connectionDefinition);
            });
            ConnectionDefinition definition = connectionInvocation.definition;
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    ReactiveStreamsConnectionOperations<?> operations = Objects.requireNonNull(connectionInvocation.reactiveStreamsConnectionOperations);
                    if (connectionInvocation.reactorConnectionOperations != null) {
                        ReactorConnectionOperations<?> reactorConnectionOperations = connectionInvocation.reactorConnectionOperations;
                        if (context.getExecutableMethod().getReturnType().isSingleResult()) {
                            return reactorConnectionOperations.withConnectionMono(definition, status -> Mono.from((Publisher)interceptedMethod.interceptResultAsPublisher()));
                        }
                        return reactorConnectionOperations.withConnectionFlux(definition, status -> Flux.from((Publisher)interceptedMethod.interceptResultAsPublisher()));
                    }
                    return interceptedMethod.handleResult(operations.withConnection(definition, status -> interceptedMethod.interceptResultAsPublisher()));
                }
                case COMPLETION_STAGE: {
                    AsyncConnectionOperations<?> operations = Objects.requireNonNull(connectionInvocation.asyncConnectionOperations);
                    return interceptedMethod.handleResult(operations.withConnection(definition, status -> interceptedMethod.interceptResultAsCompletionStage()));
                }
                case SYNCHRONOUS: {
                    ConnectionOperations<?> operations = Objects.requireNonNull(connectionInvocation.connectionOperations);
                    return operations.execute(definition, connection -> context.proceed());
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    public static @NonNull ConnectionDefinition getConnectionDefinition(ExecutableMethod<Object, Object> executableMethod) {
        AnnotationValue annotation = executableMethod.getAnnotation(Connectable.class);
        if (annotation == null) {
            throw new IllegalStateException("No declared @Connectable annotation present");
        }
        return new DefaultConnectionDefinition(executableMethod.getDeclaringType().getSimpleName() + "." + executableMethod.getMethodName(), annotation.enumValue("propagation", ConnectionDefinition.Propagation.class).orElse(ConnectionDefinition.PROPAGATION_DEFAULT), annotation.longValue("timeout").stream().mapToObj(Duration::ofSeconds).findFirst().orElse(null), annotation.booleanValue("readOnly").orElse(null));
    }

    private record TenantExecutableMethod(String dataSource, ExecutableMethod<?, ?> method) {
    }

    private record ConnectionInvocation(@Nullable ConnectionOperations<?> connectionOperations, @Nullable ReactorConnectionOperations<?> reactorConnectionOperations, @Nullable ReactiveStreamsConnectionOperations<?> reactiveStreamsConnectionOperations, @Nullable AsyncConnectionOperations<?> asyncConnectionOperations, ConnectionDefinition definition) {
        ConnectionInvocation(@Nullable ConnectionOperations<?> connectionOperations, @Nullable ReactiveStreamsConnectionOperations<?> reactiveStreamsConnectionOperations, @Nullable AsyncConnectionOperations<?> asyncConnectionOperations, ConnectionDefinition definition) {
            this(connectionOperations, reactiveStreamsConnectionOperations instanceof ReactorConnectionOperations ? (reactorReactiveConnectionOperations = (ReactorConnectionOperations)reactiveStreamsConnectionOperations) : null, reactiveStreamsConnectionOperations, asyncConnectionOperations, definition);
            ReactorConnectionOperations reactorReactiveConnectionOperations;
        }
    }
}

