/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import java.time.Duration;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public record DefaultConnectionDefinition(@Nullable String name, ConnectionDefinition.Propagation propagationBehavior, @Nullable Duration timeout, Boolean readOnlyValue, @NonNull AnnotationMetadata annotationMetadata) implements ConnectionDefinition
{
    DefaultConnectionDefinition(String name) {
        this(name, PROPAGATION_DEFAULT, null, null, AnnotationMetadata.EMPTY_METADATA);
    }

    public DefaultConnectionDefinition(ConnectionDefinition.Propagation propagationBehaviour) {
        this(null, propagationBehaviour, null, null, AnnotationMetadata.EMPTY_METADATA);
    }

    public DefaultConnectionDefinition(String name, boolean readOnly) {
        this(name, PROPAGATION_DEFAULT, null, readOnly, AnnotationMetadata.EMPTY_METADATA);
    }

    public DefaultConnectionDefinition(String name, ConnectionDefinition.Propagation propagationBehavior, Duration timeout, Boolean readOnlyValue) {
        this(name, propagationBehavior, timeout, readOnlyValue, AnnotationMetadata.EMPTY_METADATA);
    }

    @Override
    public Optional<Boolean> isReadOnly() {
        return Optional.ofNullable(this.readOnlyValue);
    }

    @Override
    public @NonNull ConnectionDefinition.Propagation getPropagationBehavior() {
        return this.propagationBehavior;
    }

    @Override
    public @NonNull Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConnectionDefinition withPropagation(ConnectionDefinition.Propagation propagation) {
        return new DefaultConnectionDefinition(this.name, propagation, this.timeout, this.readOnlyValue, this.annotationMetadata);
    }

    @Override
    public ConnectionDefinition withName(String name) {
        return new DefaultConnectionDefinition(name, this.propagationBehavior, this.timeout, this.readOnlyValue, this.annotationMetadata);
    }

    @Override
    public ConnectionDefinition withAnnotationMetadata(AnnotationMetadata newAnnotationMetadata) {
        return new DefaultConnectionDefinition(this.name, this.propagationBehavior, this.timeout, this.readOnlyValue, newAnnotationMetadata);
    }

    public @NonNull AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }
}

