/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

@Blocking
public interface ConnectionOperations<C> {
    default public @NonNull ConnectionStatus<C> getConnectionStatus() {
        return this.findConnectionStatus().orElseThrow(NoConnectionException::new);
    }

    public Optional<ConnectionStatus<C>> findConnectionStatus();

    public <R> R execute(@NonNull ConnectionDefinition var1, @NonNull Function<ConnectionStatus<C>, R> var2);

    default public <R> R executeRead(@NonNull Function<ConnectionStatus<C>, R> callback) {
        return this.execute(ConnectionDefinition.READ_ONLY, callback);
    }

    default public <R> R executeWrite(@NonNull Function<ConnectionStatus<C>, R> callback) {
        return this.execute(ConnectionDefinition.DEFAULT, callback);
    }

    public boolean managesConnection(@NonNull ConnectionStatus<C> var1);
}

