/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.data.connection.DefaultConnectionDefinition;
import java.time.Duration;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ConnectionDefinition
extends AnnotationMetadataProvider {
    public static final Propagation PROPAGATION_DEFAULT = Propagation.REQUIRED;
    public static final ConnectionDefinition DEFAULT = new DefaultConnectionDefinition("DEFAULT");
    public static final ConnectionDefinition READ_ONLY = new DefaultConnectionDefinition("READ_ONLY", true);
    public static final ConnectionDefinition REQUIRES_NEW = DEFAULT.withPropagation(Propagation.REQUIRES_NEW);

    public @NonNull Propagation getPropagationBehavior();

    public Optional<Duration> getTimeout();

    public Optional<Boolean> isReadOnly();

    public @Nullable String getName();

    public @NonNull ConnectionDefinition withPropagation(Propagation var1);

    public @NonNull ConnectionDefinition withName(String var1);

    public @NonNull ConnectionDefinition withAnnotationMetadata(AnnotationMetadata var1);

    public static @NonNull ConnectionDefinition of(@NonNull Propagation propagationBehaviour) {
        return new DefaultConnectionDefinition(propagationBehaviour);
    }

    public static @NonNull ConnectionDefinition named(@NonNull String name) {
        return new DefaultConnectionDefinition(name);
    }

    public static enum Propagation {
        REQUIRED,
        MANDATORY,
        REQUIRES_NEW;

    }
}

