/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.sync;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public final class SynchronousConnectionOperationsFromReactiveConnectionOperations<T>
implements ConnectionOperations<T> {
    private final ReactorConnectionOperations<T> reactorConnectionOperations;
    private final Scheduler scheduler;

    public SynchronousConnectionOperationsFromReactiveConnectionOperations(ReactorConnectionOperations<T> reactorConnectionOperations, ExecutorService blockingExecutorService) {
        this.reactorConnectionOperations = reactorConnectionOperations;
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)blockingExecutorService);
    }

    @Override
    public Optional<ConnectionStatus<T>> findConnectionStatus() {
        return Optional.empty();
    }

    @Override
    public <R> R execute(ConnectionDefinition definition, Function<ConnectionStatus<T>, R> callback) {
        Mono result = this.reactorConnectionOperations.withConnectionMono(definition, status -> Mono.deferContextual(contextView -> {
            try (PropagatedContext.Scope ignore = ReactorPropagation.findPropagatedContext((ContextView)contextView).orElseGet(PropagatedContext::getOrEmpty).propagate();){
                Mono mono = Mono.justOrEmpty(callback.apply((ConnectionStatus)status));
                return mono;
            }
        }).subscribeOn(this.scheduler)).contextWrite(ctx -> ReactorPropagation.addPropagatedContext((Context)ctx, (PropagatedContext)PropagatedContext.getOrEmpty()));
        return (R)result.onErrorMap(e -> {
            if (e instanceof UndeclaredThrowableException) {
                return e.getCause();
            }
            return e;
        }).block();
    }
}

