/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.ConnectionSynchronization;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;

@Internal
public final class DefaultConnectionStatus<C>
implements ConnectionStatus<C> {
    private final C connection;
    private final ConnectionDefinition definition;
    private final boolean isNew;
    private List<ConnectionSynchronization> connectionSynchronizations;

    public DefaultConnectionStatus(C connection, ConnectionDefinition definition, boolean isNew) {
        this.connection = connection;
        this.definition = definition;
        this.isNew = isNew;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public C getConnection() {
        return this.connection;
    }

    @Override
    public ConnectionDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void registerSynchronization(ConnectionSynchronization synchronization) {
        if (this.connectionSynchronizations == null) {
            this.connectionSynchronizations = new ArrayList<ConnectionSynchronization>(5);
        }
        OrderUtil.sort(this.connectionSynchronizations);
        this.connectionSynchronizations.add(synchronization);
    }

    private void forEachSynchronizations(Consumer<ConnectionSynchronization> consumer) {
        if (this.connectionSynchronizations != null) {
            ArrayList<Exception> exceptions = new ArrayList<Exception>(this.connectionSynchronizations.size());
            ListIterator<ConnectionSynchronization> listIterator = this.connectionSynchronizations.listIterator(this.connectionSynchronizations.size());
            while (listIterator.hasPrevious()) {
                try {
                    consumer.accept(listIterator.previous());
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                if (exceptions.size() == 1) {
                    DefaultConnectionStatus.sneakyThrow((Throwable)exceptions.get(0));
                } else {
                    IllegalStateException e = new IllegalStateException("Error executing connection synchronizations", (Throwable)exceptions.get(0));
                    for (int i = 1; i < exceptions.size(); ++i) {
                        e.addSuppressed((Throwable)exceptions.get(i));
                    }
                    throw e;
                }
            }
        }
    }

    private static <T extends Throwable, R> R sneakyThrow(Throwable t) throws T {
        throw t;
    }

    public void complete() {
        this.forEachSynchronizations(ConnectionSynchronization::executionComplete);
    }

    public void beforeClosed() {
        if (this.isNew) {
            this.forEachSynchronizations(ConnectionSynchronization::beforeClosed);
        }
    }

    public void afterClosed() {
        if (this.isNew) {
            this.forEachSynchronizations(ConnectionSynchronization::afterClosed);
        }
    }
}

