/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.ConnectionSynchronization;
import io.micronaut.data.connection.SynchronousConnectionManager;
import io.micronaut.data.connection.exceptions.ConnectionException;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import io.micronaut.data.connection.support.ConnectionCustomizer;
import io.micronaut.data.connection.support.DefaultConnectionStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractConnectionOperations<C>
implements ConnectionOperations<C>,
SynchronousConnectionManager<C> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ConnectionCustomizer<C>> connectionCustomizers = new ArrayList<ConnectionCustomizer<C>>(10);

    public void addConnectionCustomizer(@NonNull ConnectionCustomizer<C> connectionCustomizer) {
        this.connectionCustomizers.add(connectionCustomizer);
        OrderUtil.sort(this.connectionCustomizers);
    }

    protected abstract C openConnection(ConnectionDefinition var1);

    protected abstract void setupConnection(ConnectionStatus<C> var1);

    protected abstract void closeConnection(ConnectionStatus<C> var1);

    @Override
    public final Optional<ConnectionStatus<C>> findConnectionStatus() {
        return this.findContextElement().map(ConnectionPropagatedContextElement::status);
    }

    private Optional<ConnectionPropagatedContextElement<C>> findContextElement() {
        return PropagatedContext.getOrEmpty().findAll(ConnectionPropagatedContextElement.class).filter(element -> element.connectionOperations == this).map(element -> element).findFirst();
    }

    @Override
    public final <R> R execute(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, R> callback) {
        ConnectionPropagatedContextElement existingConnection = this.findContextElement().orElse(null);
        for (ConnectionCustomizer<C> connectionCustomizer : this.connectionCustomizers) {
            callback = connectionCustomizer.intercept(callback);
        }
        Function finalCallback = callback;
        return switch (definition.getPropagationBehavior()) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionDefinition.Propagation.REQUIRED -> {
                if (existingConnection == null) {
                    yield this.executeWithNewConnection(definition, callback);
                }
                yield this.withExistingConnectionInternal(existingConnection, callback);
            }
            case ConnectionDefinition.Propagation.MANDATORY -> {
                if (existingConnection == null) {
                    throw new NoConnectionException("No existing connection found for connection marked with propagation 'mandatory'");
                }
                yield this.withExistingConnectionInternal(existingConnection, callback);
            }
            case ConnectionDefinition.Propagation.REQUIRES_NEW -> existingConnection == null ? this.executeWithNewConnection(definition, callback) : this.suspend(existingConnection, () -> this.executeWithNewConnection(definition, finalCallback));
        };
    }

    private <R> R suspend(ConnectionPropagatedContextElement<C> existingConnectionContextElement, @NonNull Supplier<R> callback) {
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().minus(existingConnectionContextElement).propagate();){
            R r = callback.get();
            return r;
        }
    }

    private <R> R withExistingConnectionInternal(@NonNull ConnectionPropagatedContextElement<C> existingContextElement, @NonNull Function<ConnectionStatus<C>, R> callback) {
        DefaultConnectionStatus status = new DefaultConnectionStatus(existingContextElement.status.getConnection(), existingContextElement.status.getDefinition(), false);
        try {
            R r;
            block9: {
                this.setupConnection(status);
                PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().replace(existingContextElement, new ConnectionPropagatedContextElement(this, status)).propagate();
                try {
                    r = callback.apply(status);
                    if (ignore == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return r;
        }
        finally {
            this.complete(status);
        }
    }

    private <R> R executeWithNewConnection(@NonNull ConnectionDefinition definition, @NonNull Function<ConnectionStatus<C>, R> callback) {
        C connection = this.openConnection(definition);
        DefaultConnectionStatus<C> status = new DefaultConnectionStatus<C>(connection, definition, true);
        try {
            R r;
            block9: {
                PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus(new ConnectionPropagatedContextElement<C>(this, status)).propagate();
                try {
                    this.setupConnection(status);
                    r = callback.apply(status);
                    if (ignore == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return r;
        }
        finally {
            this.complete(status);
        }
    }

    @Override
    @NonNull
    public ConnectionStatus<C> getConnection(@NonNull ConnectionDefinition definition) {
        ConnectionPropagatedContextElement existingContextElement = this.findContextElement().orElse(null);
        return switch (definition.getPropagationBehavior()) {
            case ConnectionDefinition.Propagation.REQUIRED -> {
                if (existingContextElement == null) {
                    yield this.openNewConnectionInternal(definition);
                }
                yield this.reuseExistingConnectionInternal(existingContextElement);
            }
            case ConnectionDefinition.Propagation.MANDATORY -> {
                if (existingContextElement == null) {
                    throw new NoConnectionException();
                }
                yield this.reuseExistingConnectionInternal(existingContextElement);
            }
            case ConnectionDefinition.Propagation.REQUIRES_NEW -> {
                if (existingContextElement == null) {
                    yield this.openNewConnectionInternal(definition);
                }
                yield this.suspendOpenConnection(existingContextElement, () -> this.openNewConnectionInternal(definition));
            }
            default -> throw new ConnectionException("Unknown propagation: " + definition.getPropagationBehavior());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(@NonNull ConnectionStatus<C> status) {
        DefaultConnectionStatus connectionStatus = (DefaultConnectionStatus)status;
        try {
            connectionStatus.complete();
        }
        finally {
            try {
                connectionStatus.beforeClosed();
            }
            finally {
                if (connectionStatus.isNew()) {
                    this.closeConnection(status);
                }
                connectionStatus.afterClosed();
            }
        }
    }

    private DefaultConnectionStatus<C> openNewConnectionInternal(@NonNull ConnectionDefinition definition) {
        C connection = this.openConnection(definition);
        DefaultConnectionStatus<C> status = new DefaultConnectionStatus<C>(connection, definition, true);
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty().plus(new ConnectionPropagatedContextElement<C>(this, status));
        final PropagatedContext.Scope scope = propagatedContext.propagate();
        status.registerSynchronization(new ConnectionSynchronization(){

            @Override
            public void executionComplete() {
                scope.close();
            }
        });
        return status;
    }

    private DefaultConnectionStatus<C> reuseExistingConnectionInternal(@NonNull ConnectionPropagatedContextElement<C> existingContextElement) {
        DefaultConnectionStatus status = new DefaultConnectionStatus(existingContextElement.status.getConnection(), existingContextElement.status.getDefinition(), false);
        this.setupConnection(status);
        final PropagatedContext.Scope scope = PropagatedContext.getOrEmpty().replace(existingContextElement, new ConnectionPropagatedContextElement(this, status)).propagate();
        status.registerSynchronization(new ConnectionSynchronization(){

            @Override
            public void executionComplete() {
                scope.close();
            }
        });
        return status;
    }

    private DefaultConnectionStatus<C> suspendOpenConnection(ConnectionPropagatedContextElement<C> existingConnectionContextElement, @NonNull Supplier<DefaultConnectionStatus<C>> newStatusSupplier) {
        final PropagatedContext.Scope scope = PropagatedContext.getOrEmpty().minus(existingConnectionContextElement).propagate();
        DefaultConnectionStatus<C> newStatus = newStatusSupplier.get();
        newStatus.registerSynchronization(new ConnectionSynchronization(){

            @Override
            public void executionComplete() {
                scope.close();
            }
        });
        return newStatus;
    }

    private record ConnectionPropagatedContextElement<C>(ConnectionOperations<C> connectionOperations, ConnectionStatus<C> status) implements PropagatedContextElement
    {
    }
}

