/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.connection.ConnectionDefinition;
import java.time.Duration;
import java.util.Optional;

@Internal
public record DefaultConnectionDefinition(@Nullable String name, ConnectionDefinition.Propagation propagationBehavior, @Nullable Duration timeout, Boolean readOnlyValue) implements ConnectionDefinition
{
    DefaultConnectionDefinition(String name) {
        this(name, PROPAGATION_DEFAULT, null, null);
    }

    public DefaultConnectionDefinition(ConnectionDefinition.Propagation propagationBehaviour) {
        this(null, propagationBehaviour, null, null);
    }

    public DefaultConnectionDefinition(String name, boolean readOnly) {
        this(name, PROPAGATION_DEFAULT, null, readOnly);
    }

    @Override
    public Optional<Boolean> isReadOnly() {
        return Optional.ofNullable(this.readOnlyValue);
    }

    @Override
    @NonNull
    public ConnectionDefinition.Propagation getPropagationBehavior() {
        return this.propagationBehavior;
    }

    @Override
    @NonNull
    public Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConnectionDefinition withPropagation(ConnectionDefinition.Propagation propagation) {
        return new DefaultConnectionDefinition(this.name, propagation, this.timeout, this.readOnlyValue);
    }

    @Override
    public ConnectionDefinition withName(String name) {
        return new DefaultConnectionDefinition(name, this.propagationBehavior, this.timeout, this.readOnlyValue);
    }
}

