/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.connection.jdbc.advice;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.exceptions.NoConnectionException;
import io.micronaut.inject.ExecutableMethod;
import java.sql.Connection;
import org.jspecify.annotations.Nullable;

@Prototype
public final class ContextualConnectionInterceptor
implements MethodInterceptor<Connection, Object> {
    private final ConnectionOperations<Connection> connectionOperations;

    @Internal
    ContextualConnectionInterceptor(BeanContext beanContext, Qualifier<ConnectionOperations> qualifier) {
        this.connectionOperations = (ConnectionOperations)beanContext.getBean(Argument.of(ConnectionOperations.class, (Class[])new Class[]{Connection.class}), qualifier);
    }

    public @Nullable Object intercept(MethodInvocationContext<Connection, Object> context) {
        Connection connection = this.connectionOperations.findConnectionStatus().map(ConnectionStatus::getConnection).orElse(null);
        if (connection == null) {
            throw NoConnectionException.notFoundInAdvice();
        }
        ExecutableMethod method = context.getExecutableMethod();
        if (method.getName().equals("close")) {
            return null;
        }
        return method.invoke((Object)connection, context.getParameterValues());
    }
}

