/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.javadoc.JavadocDescription;
import io.micronaut.openapi.javadoc.JavadocParser;
import io.micronaut.openapi.util.Yaml;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.enums.ParameterStyle;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.links.Link;
import io.swagger.v3.oas.annotations.links.LinkParameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import org.reactivestreams.Publisher;

abstract class AbstractOpenApiVisitor {
    static final String ATTR_TEST_MODE = "io.micronaut.OPENAPI_TEST";
    static final String ATTR_OPENAPI = "io.micronaut.OPENAPI";
    static OpenAPI testReference;
    ObjectMapper jsonMapper = Json.mapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    ObjectMapper yamlMapper = Yaml.mapper();

    AbstractOpenApiVisitor() {
    }

    JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context) {
        Map<CharSequence, Object> newValues = this.toValueMap(values, context);
        return this.jsonMapper.valueToTree(newValues);
    }

    PathItem resolvePathItem(VisitorContext context, UriMatchTemplate matchTemplate) {
        PathItem pathItem;
        OpenAPI openAPI = this.resolveOpenAPI(context);
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = new Paths();
            openAPI.setPaths(paths);
        }
        if ((pathItem = (PathItem)paths.get((Object)matchTemplate.toString())) == null) {
            pathItem = new PathItem();
            paths.put((Object)matchTemplate.toString(), (Object)pathItem);
        }
        return pathItem;
    }

    OpenAPI resolveOpenAPI(VisitorContext context) {
        OpenAPI openAPI = context.get((CharSequence)ATTR_OPENAPI, OpenAPI.class).orElse(null);
        if (openAPI == null) {
            openAPI = new OpenAPI();
            context.put((CharSequence)ATTR_OPENAPI, (Object)openAPI);
            if (Boolean.getBoolean(ATTR_TEST_MODE)) {
                testReference = openAPI;
            }
        }
        return openAPI;
    }

    protected Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                AnnotationValue av = (AnnotationValue)value;
                Map<CharSequence, Object> valueMap = this.resolveAnnotationValues(context, av);
                newValues.put(key, valueMap);
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (!ArrayUtils.isNotEmpty((Object[])a)) continue;
                Object first = a[0];
                boolean areAnnotationValues = first instanceof AnnotationValue;
                if (areAnnotationValues) {
                    AnnotationValue sv;
                    Map params;
                    String annotationName = ((AnnotationValue)first).getAnnotationName();
                    if (Content.class.getName().equals(annotationName)) {
                        Map mediaTypes = this.annotationValueArrayToSubmap(a, "mediaType", context);
                        newValues.put(key, mediaTypes);
                        continue;
                    }
                    if (Link.class.getName().equals(annotationName) || Header.class.getName().equals(annotationName)) {
                        Map links = this.annotationValueArrayToSubmap(a, "name", context);
                        newValues.put(key, links);
                        continue;
                    }
                    if (LinkParameter.class.getName().equals(annotationName)) {
                        params = this.toTupleSubMap(a, "name", "expression");
                        newValues.put(key, params);
                        continue;
                    }
                    if (OAuthScope.class.getName().equals(annotationName)) {
                        params = this.toTupleSubMap(a, "name", "description");
                        newValues.put(key, params);
                        continue;
                    }
                    if (ApiResponse.class.getName().equals(annotationName)) {
                        LinkedHashMap<String, Map<CharSequence, Object>> responses = new LinkedHashMap<String, Map<CharSequence, Object>>();
                        for (Object o : a) {
                            sv = (AnnotationValue)o;
                            String name2 = sv.get((CharSequence)"responseCode", String.class).orElse("default");
                            Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
                            responses.put(name2, map);
                        }
                        newValues.put(key, responses);
                        continue;
                    }
                    if (ServerVariable.class.getName().equals(annotationName)) {
                        LinkedHashMap variables = new LinkedHashMap();
                        for (Object o : a) {
                            sv = (AnnotationValue)o;
                            Optional n = sv.get((CharSequence)"name", String.class);
                            n.ifPresent(name -> {
                                Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
                                Object dv = map.get("defaultValue");
                                if (dv != null) {
                                    map.put("default", dv);
                                }
                                variables.put(name, map);
                            });
                        }
                        newValues.put(key, variables);
                        continue;
                    }
                    if (a.length == 1) {
                        AnnotationValue av = (AnnotationValue)a[0];
                        Map<CharSequence, Object> valueMap = this.resolveAnnotationValues(context, av);
                        newValues.put(key, this.toValueMap(valueMap, context));
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Object o : a) {
                        if (o instanceof AnnotationValue) {
                            AnnotationValue av = (AnnotationValue)o;
                            Map<CharSequence, Object> valueMap = this.resolveAnnotationValues(context, av);
                            list.add(valueMap);
                            continue;
                        }
                        list.add(o);
                    }
                    newValues.put(key, list);
                    continue;
                }
                newValues.put(key, value);
                continue;
            }
            newValues.put(key, value);
        }
        return newValues;
    }

    private Map<CharSequence, Object> resolveAnnotationValues(VisitorContext context, AnnotationValue<?> av) {
        Map<CharSequence, Object> valueMap = this.toValueMap(av.getValues(), context);
        this.bindSchemaIfNeccessary(context, av, valueMap);
        String annotationName = av.getAnnotationName();
        if (Parameter.class.getName().equals(annotationName)) {
            this.normalizeEnumValues(valueMap, CollectionUtils.mapOf((Object[])new Object[]{"in", ParameterIn.class, "style", ParameterStyle.class}));
        }
        return valueMap;
    }

    private Map toTupleSubMap(Object[] a, String entryKey, String entryValue) {
        LinkedHashMap params = new LinkedHashMap();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            Optional n = sv.get((CharSequence)entryKey, String.class);
            Optional expr = sv.get((CharSequence)entryValue, String.class);
            if (!n.isPresent() || !expr.isPresent()) continue;
            params.put(n.get(), expr.get());
        }
        return params;
    }

    @Nullable
    protected Schema resolveSchema(OpenAPI openAPI, ClassElement type, VisitorContext context, @Nullable String mediaType) {
        Schema schema = null;
        if (type instanceof EnumElement) {
            schema = this.getSchemaDefinition(mediaType, openAPI, context, (Element)type);
        } else {
            boolean isPublisher = false;
            if (this.isContainerType(type)) {
                isPublisher = type.isAssignable(Publisher.class.getName()) && !type.isAssignable("reactor.core.publisher.Mono");
                type = type.getFirstTypeArgument().orElse(null);
            }
            if (type != null) {
                String typeName = type.getName();
                if (ClassUtils.isJavaLangType((String)typeName)) {
                    schema = this.getPrimitiveType(typeName);
                } else if (type.isIterable()) {
                    Optional componentType = type.getFirstTypeArgument();
                    schema = componentType.isPresent() ? this.getPrimitiveType(((ClassElement)componentType.get()).getName()) : this.getPrimitiveType(Object.class.getName());
                    if (schema != null) {
                        schema = this.arraySchema(schema);
                    } else if (componentType.isPresent()) {
                        ClassElement componentElement = (ClassElement)componentType.get();
                        schema = this.getSchemaDefinition(mediaType, openAPI, context, (Element)componentElement);
                    }
                } else {
                    schema = this.getSchemaDefinition(mediaType, openAPI, context, (Element)type);
                }
            }
            if (schema != null) {
                boolean isStream;
                boolean bl = isStream = "text/event-stream".equals(mediaType) || "application/x-json-stream".equals(mediaType);
                if (!isStream && isPublisher || type.isIterable()) {
                    schema = this.arraySchema(schema);
                }
            }
        }
        return schema;
    }

    protected Components resolveComponents(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        if (components == null) {
            components = new Components();
            openAPI.setComponents(components);
        }
        return components;
    }

    protected void processSchemaProperty(VisitorContext context, Element element, ClassElement elementType, Schema parentSchema, Schema propertySchema) {
        if (propertySchema != null) {
            propertySchema = this.bindSchemaForElement(context, element, elementType, propertySchema);
            parentSchema.addProperties(element.getName(), propertySchema);
        }
    }

    protected Schema bindSchemaForElement(VisitorContext context, Element element, ClassElement elementType, Schema schemaToBind) {
        String doc;
        boolean isIterableOrMap;
        AnnotationValue schemaAnn = element.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        if (schemaAnn != null) {
            JsonNode schemaJson = this.toJson(schemaAnn.getValues(), context);
            try {
                schemaToBind = (Schema)this.jsonMapper.readerForUpdating((Object)schemaToBind).readValue(schemaJson);
            }
            catch (IOException e) {
                context.warn("Error reading Swagger Schema for element [" + element + "]: " + e.getMessage(), element);
            }
        }
        Schema finalSchemaToBind = schemaToBind;
        boolean bl = isIterableOrMap = elementType.isIterable() || elementType.isAssignable(Map.class);
        if (isIterableOrMap) {
            if (element.isAnnotationPresent(NotEmpty.class)) {
                finalSchemaToBind.setMinItems(Integer.valueOf(1));
            }
            element.getValue(Size.class, "min", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinItems(arg_0));
            element.getValue(Size.class, "max", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaxItems(arg_0));
        } else {
            if ("string".equals(finalSchemaToBind.getType())) {
                if (element.isAnnotationPresent(NotEmpty.class) || element.isAnnotationPresent(NotBlank.class)) {
                    finalSchemaToBind.setMinLength(Integer.valueOf(1));
                }
                element.getValue(Size.class, "min", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinLength(arg_0));
                element.getValue(Size.class, "max", Integer.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaxLength(arg_0));
            }
            if (element.isAnnotationPresent(Negative.class)) {
                finalSchemaToBind.setMaximum(new BigDecimal(0));
            }
            if (element.isAnnotationPresent(NegativeOrZero.class)) {
                finalSchemaToBind.setMaximum(new BigDecimal(1));
            }
            if (element.isAnnotationPresent(Positive.class)) {
                finalSchemaToBind.setMinimum(new BigDecimal(0));
            }
            if (element.isAnnotationPresent(PositiveOrZero.class)) {
                finalSchemaToBind.setMinimum(new BigDecimal(1));
            }
            element.getValue(Max.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaximum(arg_0));
            element.getValue(Min.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinimum(arg_0));
            element.getValue(DecimalMax.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMaximum(arg_0));
            element.getValue(DecimalMin.class, BigDecimal.class).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setMinimum(arg_0));
            if (element.isAnnotationPresent(Email.class)) {
                finalSchemaToBind.setFormat("email");
            }
            element.findAnnotation(Pattern.class).flatMap(p -> p.get((CharSequence)"regexp", String.class)).ifPresent(arg_0 -> ((Schema)finalSchemaToBind).setFormat(arg_0));
        }
        Optional documentation = element.getDocumentation();
        if (StringUtils.isEmpty((CharSequence)schemaToBind.getDescription()) && (doc = (String)documentation.orElse(null)) != null) {
            JavadocDescription desc = new JavadocParser().parse(doc);
            schemaToBind.setDescription(desc.getMethodDescription());
        }
        if (element.isAnnotationPresent(Deprecated.class)) {
            schemaToBind.setDeprecated(Boolean.valueOf(true));
        }
        schemaToBind.setNullable(Boolean.valueOf(element.isAnnotationPresent(Nullable.class)));
        return schemaToBind;
    }

    private Map annotationValueArrayToSubmap(Object[] a, String classifier, VisitorContext context) {
        LinkedHashMap<String, Map<CharSequence, Object>> mediaTypes = new LinkedHashMap<String, Map<CharSequence, Object>>();
        for (Object o : a) {
            AnnotationValue sv = (AnnotationValue)o;
            String name = sv.get((CharSequence)classifier, String.class).orElse(null);
            if (name == null) continue;
            Map<CharSequence, Object> map = this.toValueMap(sv.getValues(), context);
            mediaTypes.put(name, map);
        }
        return mediaTypes;
    }

    private void bindSchemaIfNeccessary(VisitorContext context, AnnotationValue<?> av, Map<CharSequence, Object> valueMap) {
        Optional impl = av.get((CharSequence)"implementation", String.class);
        if (io.swagger.v3.oas.annotations.media.Schema.class.getName().equals(av.getAnnotationName()) && impl.isPresent()) {
            Schema schema;
            String className = (String)impl.get();
            Optional classElement = context.getClassElement(className);
            OpenAPI openAPI = this.resolveOpenAPI(context);
            if (classElement.isPresent() && (schema = this.resolveSchema(openAPI, (ClassElement)classElement.get(), context, null)) != null) {
                BeanMap beanMap = BeanMap.of((Object)schema);
                for (Map.Entry e : beanMap.entrySet()) {
                    Object v = e.getValue();
                    if (v == null) continue;
                    valueMap.put((CharSequence)e.getKey(), v);
                }
            }
        }
    }

    private Schema getSchemaDefinition(@Nullable String mediaType, OpenAPI openAPI, VisitorContext context, Element type) {
        Schema schema;
        String schemaName;
        AnnotationValue schemaValue = type.getAnnotation(io.swagger.v3.oas.annotations.media.Schema.class);
        Map<String, Schema> schemas = this.resolveSchemas(openAPI);
        if (schemaValue != null) {
            schemaName = schemaValue.get((CharSequence)"name", String.class).orElse(NameUtils.getSimpleName((String)type.getName()));
            schema = schemas.get(schemaName);
            if (schema == null) {
                JsonNode schemaJson = this.toJson(schemaValue.getValues(), context);
                try {
                    schema = (Schema)this.jsonMapper.treeToValue((TreeNode)schemaJson, Schema.class);
                    if (schema != null) {
                        if (type instanceof EnumElement) {
                            schema.setType("string");
                            schema.setEnum(((EnumElement)type).values());
                        } else {
                            this.populateSchemaProperties(mediaType, openAPI, context, type, schema);
                        }
                        schema.setName(schemaName);
                        schemas.put(schemaName, schema);
                    }
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading Swagger Parameter for element [" + type + "]: " + e.getMessage(), type);
                }
            }
        } else {
            schemaName = NameUtils.getSimpleName((String)type.getName());
            schema = schemas.get(schemaName);
            if (schema == null) {
                schema = new Schema();
                if (type instanceof EnumElement) {
                    schema.setType("string");
                    schema.setEnum(((EnumElement)type).values());
                } else {
                    schema.setType("object");
                    this.populateSchemaProperties(mediaType, openAPI, context, type, schema);
                }
                schema.setName(schemaName);
                schemas.put(schemaName, schema);
            }
        }
        if (schema != null) {
            Schema schemaRef = new Schema();
            schemaRef.set$ref("#/components/schemas/" + schema.getName());
            return schemaRef;
        }
        return null;
    }

    private void populateSchemaProperties(String mediaType, OpenAPI openAPI, VisitorContext context, Element type, Schema schema) {
        ClassElement classElement = null;
        if (type instanceof ClassElement) {
            classElement = (ClassElement)type;
        } else if (type instanceof PropertyElement) {
            classElement = ((PropertyElement)type).getType();
        } else if (type instanceof ParameterElement) {
            classElement = ((ParameterElement)type).getType();
        }
        if (classElement != null) {
            List beanProperties = classElement.getBeanProperties();
            for (PropertyElement beanProperty : beanProperties) {
                if (beanProperty.isAnnotationPresent(JsonIgnore.class) || beanProperty.isAnnotationPresent(Hidden.class)) continue;
                Schema propertySchema = this.resolveSchema(openAPI, beanProperty.getType(), context, mediaType);
                this.processSchemaProperty(context, (Element)beanProperty, beanProperty.getType(), schema, propertySchema);
            }
        }
    }

    private Map<String, Schema> resolveSchemas(OpenAPI openAPI) {
        Components components = this.resolveComponents(openAPI);
        LinkedHashMap schemas = components.getSchemas();
        if (schemas == null) {
            schemas = new LinkedHashMap();
            components.setSchemas(schemas);
        }
        return schemas;
    }

    private ArraySchema arraySchema(Schema schema) {
        if (schema == null) {
            return null;
        }
        ArraySchema arraySchema = new ArraySchema();
        arraySchema.setItems(schema);
        return arraySchema;
    }

    private Schema getPrimitiveType(String typeName) {
        Class concreteType;
        Class wrapperType;
        PrimitiveType primitiveType;
        Schema schema = null;
        Optional aClass = ClassUtils.forName((String)typeName, (ClassLoader)this.getClass().getClassLoader());
        if (aClass.isPresent() && (primitiveType = PrimitiveType.fromType((Type)(wrapperType = ReflectionUtils.getWrapperType((Class)(concreteType = (Class)aClass.get()))))) != null) {
            schema = primitiveType.createProperty();
        }
        return schema;
    }

    private boolean isContainerType(ClassElement type) {
        return CollectionUtils.setOf((Object[])new String[]{Optional.class.getName(), Future.class.getName(), Publisher.class.getName(), "io.reactivex.Single", "io.reactivex.Observable", "io.reactivex.Maybe"}).stream().anyMatch(arg_0 -> ((ClassElement)type).isAssignable(arg_0));
    }

    protected void processSecuritySchemes(ClassElement element, VisitorContext context) {
        List values = element.getAnnotationValuesByType(SecurityScheme.class);
        OpenAPI openAPI = this.resolveOpenAPI(context);
        for (AnnotationValue securityRequirementAnnotationValue : values) {
            Optional n = securityRequirementAnnotationValue.get((CharSequence)"name", String.class);
            n.ifPresent(name -> {
                Map<CharSequence, Object> map = this.toValueMap(securityRequirementAnnotationValue.getValues(), context);
                this.normalizeEnumValues(map, CollectionUtils.mapOf((Object[])new Object[]{"type", SecurityScheme.Type.class, "in", SecurityScheme.In.class}));
                JsonNode jsonNode = this.toJson(map, context);
                try {
                    Optional<Object> securityRequirement = Optional.of(this.jsonMapper.treeToValue((TreeNode)jsonNode, io.swagger.v3.oas.models.security.SecurityScheme.class));
                    securityRequirement.ifPresent(securityScheme -> this.resolveComponents(openAPI).addSecuritySchemes(name, securityScheme));
                }
                catch (JsonProcessingException e) {
                    context.warn("Error reading Swagger SecurityRequirement for element [" + element + "]: " + e.getMessage(), (Element)element);
                }
            });
        }
    }

    protected void normalizeEnumValues(Map<CharSequence, Object> paramValues, Map<String, Class<? extends Enum>> enumTypes) {
        for (Map.Entry<String, Class<? extends Enum>> entry : enumTypes.entrySet()) {
            String name = entry.getKey();
            Class<? extends Enum> enumType = entry.getValue();
            Object in = paramValues.get(name);
            if (in == null) continue;
            try {
                Enum enumInstance = Enum.valueOf(enumType, in.toString());
                paramValues.put(name, enumInstance.toString());
            }
            catch (Exception exception) {}
        }
    }
}

