/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.yaml.PackageVersion;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.Tag;

public class YAMLGenerator
extends GeneratorBase {
    private static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    private static final Pattern PLAIN_NUMBER_P = Pattern.compile("[0-9]*(\\.[0-9]*)?");
    private static final String TAG_BINARY = Tag.BINARY.toString();
    private static final ImplicitTuple NO_TAGS = new ImplicitTuple(true, true);
    private static final ImplicitTuple EXPLICIT_TAGS = new ImplicitTuple(false, false);
    private static final DumperOptions.ScalarStyle STYLE_NAME = DumperOptions.ScalarStyle.PLAIN;
    private static final DumperOptions.ScalarStyle STYLE_SCALAR = DumperOptions.ScalarStyle.PLAIN;
    private static final DumperOptions.ScalarStyle STYLE_QUOTED = DumperOptions.ScalarStyle.DOUBLE_QUOTED;
    private static final DumperOptions.ScalarStyle STYLE_LITERAL;
    private static final DumperOptions.ScalarStyle STYLE_BASE64;
    private static final DumperOptions.ScalarStyle STYLE_PLAIN;
    private int _formatFeatures;
    private Writer _writer;
    private DumperOptions _outputOptions;
    private Emitter _emitter;
    private String _objectId;
    private String _typeId;

    YAMLGenerator(IOContext ctxt, int jsonFeatures, int yamlFeatures, ObjectCodec codec, Writer out, DumperOptions.Version version) throws IOException {
        super(jsonFeatures, codec);
        this._formatFeatures = yamlFeatures;
        this._writer = out;
        this._outputOptions = this.buildDumperOptions();
        this._emitter = new Emitter(this._writer, this._outputOptions);
        this._emitter.emit((Event)new StreamStartEvent(null, null));
        Map noTags = Collections.emptyMap();
        boolean startMarker = Feature.WRITE_DOC_START_MARKER.enabledIn(yamlFeatures);
        this._emitter.emit((Event)new DocumentStartEvent(null, null, startMarker, version, noTags));
    }

    private DumperOptions buildDumperOptions() {
        DumperOptions opt = new DumperOptions();
        if (Feature.CANONICAL_OUTPUT.enabledIn(this._formatFeatures)) {
            opt.setCanonical(true);
        } else {
            opt.setCanonical(false);
            opt.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        }
        opt.setSplitLines(Feature.SPLIT_LINES.enabledIn(this._formatFeatures));
        if (Feature.INDENT_ARRAYS.enabledIn(this._formatFeatures)) {
            opt.setIndicatorIndent(1);
            opt.setIndent(2);
        }
        return opt;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public YAMLGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public YAMLGenerator setPrettyPrinter(PrettyPrinter pp) {
        return this;
    }

    public Object getOutputTarget() {
        return this._writer;
    }

    public int getOutputBuffered() {
        return -1;
    }

    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    public JsonGenerator overrideFormatFeatures(int values, int mask) {
        this._formatFeatures = this._formatFeatures & ~mask | values & mask;
        return this;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public boolean canWriteFormattedNumbers() {
        return true;
    }

    public final void writeFieldName(String name) throws IOException {
        if (this._writeContext.writeFieldName(name) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.writeFieldNameInternal(name);
    }

    public final void writeFieldName(SerializableString name) throws IOException {
        if (this._writeContext.writeFieldName(name.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.writeFieldNameInternal(name.getValue());
    }

    public final void writeStringField(String fieldName, String value) throws IOException {
        if (this._writeContext.writeFieldName(fieldName) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this.writeFieldNameInternal(fieldName);
        this.writeString(value);
    }

    private void writeFieldNameInternal(String name) throws IOException {
        this.writeScalar(name, STYLE_NAME);
    }

    public final void flush() throws IOException {
        this._writer.flush();
    }

    public void close() throws IOException {
        if (!this.isClosed()) {
            this._emitter.emit((Event)new DocumentEndEvent(null, null, false));
            this._emitter.emit((Event)new StreamEndEvent(null, null));
            super.close();
            this._writer.close();
        }
    }

    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        DumperOptions.FlowStyle style = this._outputOptions.getDefaultFlowStyle();
        String yamlTag = this._typeId;
        boolean implicit = yamlTag == null;
        String anchor = this._objectId;
        if (anchor != null) {
            this._objectId = null;
        }
        this._emitter.emit((Event)new SequenceStartEvent(anchor, yamlTag, implicit, null, null, style));
    }

    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit((Event)new SequenceEndEvent(null, null));
    }

    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        DumperOptions.FlowStyle style = this._outputOptions.getDefaultFlowStyle();
        String yamlTag = this._typeId;
        boolean implicit = yamlTag == null;
        String anchor = this._objectId;
        if (anchor != null) {
            this._objectId = null;
        }
        this._emitter.emit((Event)new MappingStartEvent(anchor, yamlTag, implicit, null, null, style));
    }

    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        this._typeId = null;
        this._writeContext = this._writeContext.getParent();
        this._emitter.emit((Event)new MappingEndEvent(null, null));
    }

    public void writeString(String text) throws IOException {
        if (text == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        DumperOptions.ScalarStyle style = STYLE_QUOTED;
        if (Feature.MINIMIZE_QUOTES.enabledIn(this._formatFeatures) && !this.isBooleanContent(text)) {
            style = Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS.enabledIn(this._formatFeatures) && PLAIN_NUMBER_P.matcher(text).matches() ? STYLE_QUOTED : (text.indexOf(10) >= 0 ? STYLE_LITERAL : STYLE_PLAIN);
        } else if (Feature.LITERAL_BLOCK_STYLE.enabledIn(this._formatFeatures) && text.indexOf(10) >= 0) {
            style = STYLE_LITERAL;
        }
        this.writeScalar(text, style);
    }

    private boolean isBooleanContent(String text) {
        return text.equals("true") || text.equals("false");
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len));
    }

    public final void writeString(SerializableString sstr) throws IOException {
        this.writeString(sstr.toString());
    }

    public void writeRawUTF8String(byte[] text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public final void writeUTF8String(byte[] text, int offset, int len) throws IOException {
        this.writeString(new String(text, offset, len, "UTF-8"));
    }

    public void writeRaw(String text) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (data == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        this.writeScalarBinary(b64variant, data);
    }

    public void writeBoolean(boolean state) throws IOException {
        this._verifyValueWrite("write boolean value");
        this.writeScalar(state ? "true" : "false", STYLE_SCALAR);
    }

    public void writeNumber(int i) throws IOException {
        this._verifyValueWrite("write number");
        this.writeScalar(String.valueOf(i), STYLE_SCALAR);
    }

    public void writeNumber(long l) throws IOException {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        this.writeScalar(String.valueOf(l), STYLE_SCALAR);
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (v == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this.writeScalar(String.valueOf(v.toString()), STYLE_SCALAR);
    }

    public void writeNumber(double d) throws IOException {
        this._verifyValueWrite("write number");
        this.writeScalar(String.valueOf(d), STYLE_SCALAR);
    }

    public void writeNumber(float f) throws IOException {
        this._verifyValueWrite("write number");
        this.writeScalar(String.valueOf(f), STYLE_SCALAR);
    }

    public void writeNumber(BigDecimal dec) throws IOException {
        if (dec == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this.writeScalar(str, STYLE_SCALAR);
    }

    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        if (encodedValue == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this.writeScalar(encodedValue, STYLE_SCALAR);
    }

    public void writeNull() throws IOException {
        this._verifyValueWrite("write null value");
        this.writeScalar("null", STYLE_SCALAR);
    }

    public boolean canWriteObjectId() {
        return Feature.USE_NATIVE_OBJECT_ID.enabledIn(this._formatFeatures);
    }

    public boolean canWriteTypeId() {
        return Feature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    public void writeTypeId(Object id) {
        this._typeId = String.valueOf(id);
    }

    public void writeObjectRef(Object id) throws IOException {
        this._verifyValueWrite("write Object reference");
        AliasEvent evt = new AliasEvent(String.valueOf(id), null, null);
        this._emitter.emit((Event)evt);
    }

    public void writeObjectId(Object id) {
        this._objectId = String.valueOf(id);
    }

    protected final void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    protected void _releaseBuffers() {
    }

    private void writeScalar(String value, DumperOptions.ScalarStyle style) throws IOException {
        this._emitter.emit((Event)this.scalarEvent(value, style));
    }

    private void writeScalarBinary(Base64Variant b64variant, byte[] data) throws IOException {
        if (b64variant == Base64Variants.getDefaultVariant()) {
            b64variant = Base64Variants.MIME;
        }
        String encoded = b64variant.encode(data);
        this._emitter.emit((Event)new ScalarEvent(null, TAG_BINARY, EXPLICIT_TAGS, encoded, null, null, STYLE_BASE64));
    }

    private ScalarEvent scalarEvent(String value, DumperOptions.ScalarStyle style) {
        String anchor;
        String yamlTag = this._typeId;
        if (yamlTag != null) {
            this._typeId = null;
        }
        if ((anchor = this._objectId) != null) {
            this._objectId = null;
        }
        return new ScalarEvent(anchor, yamlTag, NO_TAGS, value, null, null, style);
    }

    static {
        STYLE_BASE64 = STYLE_LITERAL = DumperOptions.ScalarStyle.LITERAL;
        STYLE_PLAIN = DumperOptions.ScalarStyle.PLAIN;
    }

    public static enum Feature implements FormatFeature
    {
        WRITE_DOC_START_MARKER(true),
        USE_NATIVE_OBJECT_ID(true),
        USE_NATIVE_TYPE_ID(true),
        CANONICAL_OUTPUT(false),
        SPLIT_LINES(true),
        MINIMIZE_QUOTES(false),
        ALWAYS_QUOTE_NUMBERS_AS_STRINGS(false),
        LITERAL_BLOCK_STYLE(false),
        INDENT_ARRAYS(false);

        protected final boolean _defaultState;
        protected final int _mask;

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

