/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.CacheManager;
import io.micronaut.cache.DynamicCacheManager;
import io.micronaut.cache.SyncCache;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Singleton
@Primary
public class DefaultCacheManager<C>
implements CacheManager<C> {
    private final Map<String, SyncCache<C>> cacheMap;
    private final BeanProvider<DynamicCacheManager<C>> dynamicCacheManager;

    @Inject
    public DefaultCacheManager(List<SyncCache<C>> caches, @Nullable BeanProvider<DynamicCacheManager<C>> dynamicCacheManager) {
        this.dynamicCacheManager = dynamicCacheManager;
        if (CollectionUtils.isEmpty(caches)) {
            this.cacheMap = new LinkedHashMap<String, SyncCache<C>>();
        } else {
            this.cacheMap = new LinkedHashMap<String, SyncCache<C>>(caches.size());
            for (SyncCache<C> cache : caches) {
                String cacheName = cache.getName();
                if (this.cacheMap.containsKey(cacheName)) {
                    throw new ConfigurationException("Cannot registry duplicate cache [" + String.valueOf(cache) + "] with cache manager. Ensure configured cache names are unique. Cache already configured for name [" + cacheName + "]: " + String.valueOf(this.cacheMap.get(cacheName)));
                }
                this.cacheMap.put(cacheName, cache);
            }
        }
    }

    public DefaultCacheManager(SyncCache<C> ... caches) {
        this(Arrays.asList(caches), null);
    }

    @Override
    @NonNull
    public Set<String> getCacheNames() {
        return this.cacheMap.keySet();
    }

    @Override
    @NonNull
    public SyncCache<C> getCache(String name) {
        SyncCache<C> cache = this.cacheMap.get(name);
        if (cache == null) {
            if (this.dynamicCacheManager != null) {
                cache = ((DynamicCacheManager)this.dynamicCacheManager.get()).getCache(name);
                Objects.requireNonNull(cache);
                this.cacheMap.put(name, cache);
            } else {
                throw new ConfigurationException("No cache configured for name: " + name);
            }
        }
        return cache;
    }
}

