/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.micronaut.cache.CacheConfiguration;
import io.micronaut.cache.CacheInfo;
import io.micronaut.cache.SyncCache;
import io.micronaut.cache.caffeine.DefaultCacheConfiguration;
import io.micronaut.cache.caffeine.configuration.CaffeineCacheConfiguration;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@EachBean(value=CacheConfiguration.class)
public class DefaultSyncCache
implements SyncCache<Cache> {
    private final CacheConfiguration cacheConfiguration;
    private final Cache cache;
    private final ApplicationContext applicationContext;
    private final ConversionService conversionService;

    public DefaultSyncCache(DefaultCacheConfiguration cacheConfiguration, ApplicationContext applicationContext, ConversionService conversionService) {
        this((CacheConfiguration)cacheConfiguration, applicationContext, conversionService);
    }

    @Inject
    public DefaultSyncCache(CacheConfiguration cacheConfiguration, ApplicationContext applicationContext, ConversionService conversionService) {
        this.cacheConfiguration = cacheConfiguration;
        this.applicationContext = applicationContext;
        this.conversionService = conversionService;
        this.cache = this.buildCache(cacheConfiguration);
    }

    public Publisher<CacheInfo> getCacheInfo() {
        return Flux.just((Object)new CacheInfo(){

            @NonNull
            public String getName() {
                return DefaultSyncCache.this.cacheConfiguration.getCacheName();
            }

            @NonNull
            public Map<String, Object> get() {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(2);
                data.put("implementationClass", DefaultSyncCache.this.getNativeCache().getClass().getName());
                data.put("caffeine", DefaultSyncCache.this.getCaffeineCacheData(DefaultSyncCache.this.cache));
                return data;
            }
        });
    }

    public String getName() {
        return this.cacheConfiguration.getCacheName();
    }

    public Cache getNativeCache() {
        return this.cache;
    }

    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        Object value = this.cache.getIfPresent(key);
        if (value != null) {
            return this.conversionService.convert(value, ConversionContext.of(requiredType));
        }
        return Optional.empty();
    }

    public <T> T get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        Object value = this.cache.get(key, o -> supplier.get());
        if (value != null) {
            Optional converted = this.conversionService.convert(value, ConversionContext.of(requiredType));
            return converted.orElseThrow(() -> new IllegalArgumentException("Cache supplier returned a value that cannot be converted to type: " + requiredType.getName()));
        }
        return (T)value;
    }

    public void invalidate(Object key) {
        this.cache.invalidate(key);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void put(@NonNull Object key, @Nullable Object value) {
        if (value == null) {
            this.cache.invalidate(key);
        } else {
            this.cache.put(key, value);
        }
    }

    public <T> Optional<T> putIfAbsent(Object key, T value) {
        T previous = this.cache.asMap().putIfAbsent(key, value);
        return Optional.ofNullable(previous);
    }

    public <T> T putIfAbsent(Object key, Supplier<T> value) {
        Object val = this.cache.asMap().computeIfAbsent(key, k -> value.get());
        return (T)val;
    }

    protected Cache buildCache(CacheConfiguration cacheConfiguration) {
        RemovalListener<Object, Object> removalListener;
        CaffeineCacheConfiguration caffeineCacheConfiguration;
        Caffeine builder = Caffeine.newBuilder();
        cacheConfiguration.getExpireAfterAccess().ifPresent(duration -> builder.expireAfterAccess(duration.toMillis(), TimeUnit.MILLISECONDS));
        cacheConfiguration.getExpireAfterWrite().ifPresent(duration -> builder.expireAfterWrite(duration.toMillis(), TimeUnit.MILLISECONDS));
        cacheConfiguration.getInitialCapacity().ifPresent(arg_0 -> ((Caffeine)builder).initialCapacity(arg_0));
        cacheConfiguration.getMaximumSize().ifPresent(arg_0 -> ((Caffeine)builder).maximumSize(arg_0));
        cacheConfiguration.getMaximumWeight().ifPresent(weight -> {
            builder.maximumWeight(weight);
            builder.weigher(this.findWeigher());
        });
        CaffeineCacheConfiguration caffeineCacheConfiguration2 = caffeineCacheConfiguration = cacheConfiguration instanceof CaffeineCacheConfiguration ? (CaffeineCacheConfiguration)cacheConfiguration : null;
        if (caffeineCacheConfiguration != null && (removalListener = this.findRemovalListener()) != null) {
            if (caffeineCacheConfiguration.isListenToRemovals()) {
                builder.removalListener((key, value, cause) -> removalListener.onRemoval(key, value, cause));
            }
            if (caffeineCacheConfiguration.isListenToEvictions()) {
                builder.evictionListener((key, value, cause) -> removalListener.onRemoval(key, value, cause));
            }
        }
        if (cacheConfiguration.isRecordStats()) {
            builder.recordStats();
        }
        if (cacheConfiguration.isTestMode()) {
            builder.executor(Runnable::run);
        }
        return builder.build();
    }

    private Weigher<Object, Object> findWeigher() {
        return this.applicationContext.findBean(Weigher.class, Qualifiers.byName((String)this.cacheConfiguration.getCacheName())).orElseGet(() -> this.applicationContext.findBean(Weigher.class).orElse(Weigher.singletonWeigher()));
    }

    private RemovalListener<Object, Object> findRemovalListener() {
        return this.applicationContext.findBean(RemovalListener.class, Qualifiers.byName((String)this.cacheConfiguration.getCacheName())).orElseGet(() -> this.applicationContext.findBean(RemovalListener.class).orElse(null));
    }

    private Map<String, Object> getCaffeineCacheData(Cache caffeineCache) {
        Policy policy = caffeineCache.policy();
        Optional eviction = policy.eviction();
        Optional expireAfterAccess = policy.expireAfterAccess();
        Optional expireAfterWrite = policy.expireAfterWrite();
        Long maximumSize = eviction.filter(e -> !e.isWeighted()).map(e -> e.getMaximum()).orElse(null);
        Long maximumWeight = eviction.filter(e -> e.isWeighted()).map(e -> e.getMaximum()).orElse(null);
        Long weightedSize = eviction.flatMap(e -> e.weightedSize().isPresent() ? Optional.of(e.weightedSize().getAsLong()) : Optional.empty()).orElse(null);
        boolean isRecordingStats = policy.isRecordingStats();
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(8);
        values.put("estimatedSize", caffeineCache.estimatedSize());
        values.put("maximumSize", maximumSize);
        values.put("maximumWeight", maximumWeight);
        values.put("weightedSize", weightedSize);
        values.put("expireAfterAccess", this.getExpiresAfter(expireAfterAccess));
        values.put("expireAfterWrite", this.getExpiresAfter(expireAfterWrite));
        values.put("recordingStats", isRecordingStats);
        if (isRecordingStats) {
            values.put("stats", this.getStatsData(caffeineCache.stats()));
        }
        return values;
    }

    private Long getExpiresAfter(Optional<Policy.FixedExpiration> expiration) {
        return expiration.map(e -> e.getExpiresAfter(TimeUnit.MILLISECONDS)).orElse(null);
    }

    private Map<String, Object> getStatsData(CacheStats stats) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(13);
        values.put("requestCount", stats.requestCount());
        values.put("hitCount", stats.hitCount());
        values.put("hitRate", stats.hitRate());
        values.put("missCount", stats.missCount());
        values.put("missRate", stats.missRate());
        values.put("evictionCount", stats.evictionCount());
        values.put("evictionWeight", stats.evictionWeight());
        return values;
    }
}

