/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageInScope;
import io.micrometer.tracing.ScopedSpan;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.test.simple.SimpleBaggageManager;
import io.micrometer.tracing.test.simple.SimpleCurrentTraceContext;
import io.micrometer.tracing.test.simple.SimpleScopedSpan;
import io.micrometer.tracing.test.simple.SimpleSpan;
import io.micrometer.tracing.test.simple.SimpleSpanBuilder;
import io.micrometer.tracing.test.simple.SimpleSpanCustomizer;
import io.micrometer.tracing.test.simple.SimpleSpanInScope;
import io.micrometer.tracing.test.simple.SimpleTraceContextBuilder;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.jspecify.annotations.Nullable;

public class SimpleTracer
implements Tracer {
    private static final Map<TraceContext, SimpleSpan> traceContextToSpans = new ConcurrentHashMap<TraceContext, SimpleSpan>();
    private static final ThreadLocal<SimpleSpan> scopedSpans = new ThreadLocal();
    private final SimpleCurrentTraceContext currentTraceContext;
    final SimpleBaggageManager simpleBaggageManager = new SimpleBaggageManager(this);
    private final Deque<SimpleSpan> spans = new LinkedBlockingDeque<SimpleSpan>();

    public SimpleTracer() {
        this.currentTraceContext = new SimpleCurrentTraceContext(this);
    }

    public SimpleSpan nextSpan(@Nullable Span parent) {
        SimpleSpan span = this.simpleSpan(parent);
        this.spans.add(span);
        return span;
    }

    private SimpleSpan simpleSpan(@Nullable Span parent) {
        Map<String, String> baggageFromParent = Collections.emptyMap();
        SimpleSpan span = new SimpleSpan();
        if (parent != null) {
            span.context().setParentId(parent.context().spanId());
            baggageFromParent = this.simpleBaggageManager.getAllBaggageForCtx(parent.context());
        }
        String traceId = parent != null ? parent.context().traceId() : span.context().generateId();
        span.context().setTraceId(traceId);
        span.context().setSpanId(parent != null ? span.context().generateId() : traceId);
        span.context().addParentBaggage(baggageFromParent);
        return span;
    }

    public SimpleSpan onlySpan() {
        this.assertTrue(this.spans.size() == 1, "There must be only one span");
        SimpleSpan span = this.spans.getFirst();
        this.assertTrue(span.getStartTimestamp().toEpochMilli() > 0L, "Span must be started");
        this.assertTrue(span.getEndTimestamp().toEpochMilli() > 0L, "Span must be finished");
        return span;
    }

    private void assertTrue(boolean condition, String text) {
        if (!condition) {
            throw new AssertionError((Object)text);
        }
    }

    public SimpleSpan lastSpan() {
        this.assertTrue(!this.spans.isEmpty(), "There must be at least one span");
        SimpleSpan span = this.spans.getLast();
        this.assertTrue(span.getStartTimestamp().toEpochMilli() > 0L, "Span must be started");
        return span;
    }

    public SimpleSpanInScope withSpan(@Nullable Span span) {
        return new SimpleSpanInScope(this.currentTraceContext.newScope(span != null ? span.context() : null));
    }

    public SimpleSpanCustomizer currentSpanCustomizer() {
        return new SimpleSpanCustomizer(this);
    }

    public @Nullable SimpleSpan currentSpan() {
        return scopedSpans.get();
    }

    public SimpleSpan nextSpan() {
        SimpleSpan span = this.simpleSpan(this.currentSpan());
        this.spans.add(span);
        return span;
    }

    public ScopedSpan startScopedSpan(String name) {
        return new SimpleScopedSpan(this).name(name);
    }

    public SimpleSpanBuilder spanBuilder() {
        return new SimpleSpanBuilder(this);
    }

    public TraceContext.Builder traceContextBuilder() {
        return new SimpleTraceContextBuilder();
    }

    public SimpleCurrentTraceContext currentTraceContext() {
        return this.currentTraceContext;
    }

    public Map<String, String> getAllBaggage() {
        return this.simpleBaggageManager.getAllBaggage();
    }

    public Baggage getBaggage(String name) {
        return this.simpleBaggageManager.getBaggage(name);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        return this.simpleBaggageManager.getBaggage(traceContext, name);
    }

    public Map<String, String> getAllBaggage(@Nullable TraceContext traceContext) {
        if (traceContext == null) {
            return this.simpleBaggageManager.getAllBaggage();
        }
        return this.simpleBaggageManager.getAllBaggageForCtx(traceContext);
    }

    public Baggage createBaggage(String name) {
        return this.simpleBaggageManager.createBaggage(name);
    }

    public Baggage createBaggage(String name, String value) {
        return this.simpleBaggageManager.createBaggage(name, value);
    }

    public BaggageInScope createBaggageInScope(String name, String value) {
        return this.simpleBaggageManager.createBaggageInScope(name, value);
    }

    public BaggageInScope createBaggageInScope(TraceContext traceContext, String name, String value) {
        return this.simpleBaggageManager.createBaggageInScope(traceContext, name, value);
    }

    public List<String> getBaggageFields() {
        return this.simpleBaggageManager.getBaggageFields();
    }

    public Deque<SimpleSpan> getSpans() {
        return this.spans;
    }

    static void bindSpanToTraceContext(TraceContext traceContext, SimpleSpan span) {
        traceContextToSpans.put(traceContext, span);
    }

    static @Nullable SimpleSpan getSpanForTraceContext(TraceContext traceContext) {
        return traceContextToSpans.get(traceContext);
    }

    static SimpleSpan getCurrentSpan() {
        return scopedSpans.get();
    }

    static void resetCurrentSpan() {
        scopedSpans.remove();
    }

    static void setCurrentSpan(SimpleSpan simpleSpan) {
        scopedSpans.set(simpleSpan);
    }

    static void setCurrentSpan(TraceContext context) {
        scopedSpans.set(context != null ? SimpleTracer.getSpanForTraceContext(context) : null);
    }
}

