/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.test.simple;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.Baggage;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.BaggageView;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.test.simple.SimpleBaggageInScope;
import io.micrometer.tracing.test.simple.SimpleTracer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SimpleBaggageManager
implements BaggageManager {
    private final Map<TraceContext, Set<SimpleBaggageInScope>> baggagesByContext = new ConcurrentHashMap<TraceContext, Set<SimpleBaggageInScope>>();
    private final SimpleTracer simpleTracer;

    public SimpleBaggageManager(SimpleTracer simpleTracer) {
        this.simpleTracer = simpleTracer;
    }

    public Map<String, String> getAllBaggage() {
        return this.baggagesByContext.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BaggageView::name, BaggageView::get));
    }

    public Baggage getBaggage(String name) {
        return this.getBaggage(this.simpleTracer.currentTraceContext().context(), name);
    }

    public Baggage getBaggage(TraceContext traceContext, String name) {
        return this.baggageForName(traceContext, name);
    }

    @Nullable
    private SimpleBaggageInScope baggageForName(TraceContext traceContext, String name) {
        return this.baggagesByContext.getOrDefault(traceContext, Collections.emptySet()).stream().filter(bag -> name.equalsIgnoreCase(bag.name())).findFirst().orElse(null);
    }

    public Baggage createBaggage(String name) {
        return this.createSimpleBaggage(name);
    }

    private Baggage createSimpleBaggage(String name) {
        TraceContext current = this.simpleTracer.currentTraceContext().context();
        SimpleBaggageInScope baggage = this.baggageForName(current, name);
        if (baggage == null) {
            baggage = new SimpleBaggageInScope(name);
        }
        Set baggages = this.baggagesByContext.getOrDefault(current, new HashSet());
        baggages.add(baggage);
        this.baggagesByContext.put(current, baggages);
        return baggage;
    }

    public Baggage createBaggage(String name, String value) {
        Baggage baggage = this.createSimpleBaggage(name);
        baggage.set(value);
        return baggage;
    }
}

