/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.core.lang.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class CacheMeterBinderCompatibilityKit {
    private MeterRegistry registry = new SimpleMeterRegistry();
    private CacheMeterBinder binder;

    public abstract CacheMeterBinder binder();

    public abstract void put(String var1, String var2);

    @Nullable
    public abstract String get(String var1);

    @BeforeEach
    void bindToRegistry() {
        this.binder = this.binder();
        this.binder.bindTo(this.registry);
    }

    @Test
    void size() {
        this.put("k", "v");
        Assertions.assertThat((Long)this.binder.size()).isIn(new Object[]{null, 1L});
        if (this.binder.size() != null) {
            Assertions.assertThat((double)this.registry.get("cache.size").tag("cache", "mycache").gauge().value()).isEqualTo(1.0);
        }
    }

    @Test
    void puts() {
        this.put("k", "v");
        Assertions.assertThat((long)this.binder.putCount()).isEqualTo(1L);
        Assertions.assertThat((double)this.registry.get("cache.puts").tag("cache", "mycache").functionCounter().count()).isEqualTo(1.0);
    }

    @Test
    void gets() {
        this.put("k", "v");
        this.get("k");
        this.get("does.not.exist");
        Assertions.assertThat((long)this.binder.hitCount()).isEqualTo(1L);
        Assertions.assertThat((double)this.registry.get("cache.gets").tag("result", "hit").tag("cache", "mycache").functionCounter().count()).isEqualTo(1.0);
        if (this.binder.missCount() != null) {
            Assertions.assertThat((Long)this.binder.missCount()).isIn(new Object[]{1L, 2L});
            Assertions.assertThat((double)this.registry.get("cache.gets").tag("result", "miss").tag("cache", "mycache").functionCounter().count()).isIn(new Object[]{1.0, 2.0});
        }
    }
}

