/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.test.assertions;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;

public class MeterAssert<METER extends Meter>
extends AbstractAssert<MeterAssert<METER>, METER> {
    @CheckReturnValue
    public static <M extends Meter> MeterAssert<M> assertThat(M actual) {
        return new MeterAssert<M>(actual, MeterAssert.class);
    }

    private MeterAssert(METER actual, Class<? extends MeterAssert> type) {
        super(actual, type);
    }

    public MeterAssert<METER> hasMeasurement(Statistic statistic, double expectedValue) {
        Optional<Double> measurement = StreamSupport.stream(((Meter)this.actual).measure().spliterator(), false).filter(m -> m.getStatistic() == statistic).findAny().map(Measurement::getValue);
        ((OptionalAssert)((OptionalAssert)Assertions.assertThat(measurement).as("Meter %s should have a measurement for statistic %s with value %s", new Object[]{this.actual, statistic, expectedValue})).isPresent()).hasValue((Object)expectedValue);
        return this;
    }

    public <M extends Meter> MeterAssert<?> hasType(Class<M> expectedType) {
        Assertions.assertThat((Object)((Meter)this.actual())).isInstanceOf(expectedType);
        return this;
    }
}

