/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.tck;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.test.assertions.CounterAssert;
import io.micrometer.test.assertions.GaugeAssert;
import io.micrometer.test.assertions.MeterAssert;
import io.micrometer.test.assertions.TimerAssert;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public class MeterRegistryAssert
extends AbstractAssert<MeterRegistryAssert, MeterRegistry> {
    protected MeterRegistryAssert(MeterRegistry actual) {
        super((Object)actual, MeterRegistryAssert.class);
    }

    @CheckReturnValue
    public static MeterRegistryAssert assertThat(MeterRegistry actual) {
        return new MeterRegistryAssert(actual);
    }

    @CheckReturnValue
    public static MeterRegistryAssert then(MeterRegistry actual) {
        return new MeterRegistryAssert(actual);
    }

    public MeterRegistryAssert hasNoMetrics() {
        this.isNotNull();
        List metricsNames = ((MeterRegistry)this.actual).getMeters().stream().map(meter -> meter.getId().getName()).collect(Collectors.toList());
        if (!metricsNames.isEmpty()) {
            this.failWithMessage("Expected no metrics, but got metrics with following names <%s>", new Object[]{String.join((CharSequence)",", metricsNames)});
        }
        return this;
    }

    public MeterRegistryAssert hasMeterWithName(String meterName) {
        this.isNotNull();
        Meter foundMeter = ((MeterRegistry)this.actual).find(meterName).meter();
        if (foundMeter == null) {
            this.failWithMessage("Expected a meter with name <%s> but found none.\nFound following metrics %s", new Object[]{meterName, this.allMetrics()});
        }
        return this;
    }

    public MeterRegistryAssert hasTimerWithName(String timerName) {
        this.isNotNull();
        Timer foundTimer = ((MeterRegistry)this.actual).find(timerName).timer();
        if (foundTimer == null) {
            this.failWithMessage("Expected a timer with name <%s> but found none.\nFound following metrics %s", new Object[]{timerName, this.allMetrics()});
        }
        return this;
    }

    public MeterRegistryAssert doesNotHaveMeterWithName(String meterName) {
        this.isNotNull();
        Meter foundMeter = ((MeterRegistry)this.actual).find(meterName).meter();
        if (foundMeter != null) {
            this.failWithMessage("Expected no meter with name <%s> but found one with tags <%s>", new Object[]{meterName, foundMeter.getId().getTags()});
        }
        return this;
    }

    public MeterRegistryAssert doesNotHaveTimerWithName(String timerName) {
        this.isNotNull();
        Timer foundTimer = ((MeterRegistry)this.actual).find(timerName).timer();
        if (foundTimer != null) {
            this.failWithMessage("Expected no timer with name <%s> but found one with tags <%s>", new Object[]{timerName, foundTimer.getId().getTags()});
        }
        return this;
    }

    public MeterRegistryAssert hasMeterWithNameAndTags(String meterName, Tags tags) {
        this.isNotNull();
        Meter foundMeter = ((MeterRegistry)this.actual).find(meterName).tags((Iterable)tags).meter();
        if (foundMeter == null) {
            this.failWithMessage("Expected a meter with name <%s> and tags <%s> but found none.\nFound following metrics %s", new Object[]{meterName, tags, this.allMetrics()});
        }
        return this;
    }

    public MeterRegistryAssert hasTimerWithNameAndTags(String timerName, Tags tags) {
        this.isNotNull();
        Timer foundTimer = ((MeterRegistry)this.actual).find(timerName).tags((Iterable)tags).timer();
        if (foundTimer == null) {
            this.failWithMessage("Expected a timer with name <%s> and tags <%s> but found none.\nFound following metrics %s", new Object[]{timerName, tags, this.allMetrics()});
        }
        return this;
    }

    public MeterRegistryAssert hasMeterWithNameAndTags(String meterName, KeyValues tags) {
        return this.hasMeterWithNameAndTags(meterName, this.toMicrometerTags(tags));
    }

    public MeterRegistryAssert hasTimerWithNameAndTags(String timerName, KeyValues tags) {
        return this.hasTimerWithNameAndTags(timerName, this.toMicrometerTags(tags));
    }

    private Tags toMicrometerTags(KeyValues tags) {
        Tag[] array = (Tag[])tags.stream().map(tag -> Tag.of((String)tag.getKey(), (String)tag.getValue())).toArray(Tag[]::new);
        return Tags.of((Tag[])array);
    }

    public MeterRegistryAssert doesNotHaveMeterWithNameAndTags(String meterName, Tags tags) {
        this.isNotNull();
        Meter foundMeter = ((MeterRegistry)this.actual).find(meterName).tags((Iterable)tags).meter();
        if (foundMeter != null) {
            this.failWithMessage("Expected no meter with name <%s> and tags <%s> but found one", new Object[]{meterName, tags});
        }
        return this;
    }

    public MeterRegistryAssert doesNotHaveTimerWithNameAndTags(String timerName, Tags tags) {
        this.isNotNull();
        Timer foundTimer = ((MeterRegistry)this.actual).find(timerName).tags((Iterable)tags).timer();
        if (foundTimer != null) {
            this.failWithMessage("Expected no timer with name <%s> and tags <%s> but found one", new Object[]{timerName, tags});
        }
        return this;
    }

    public MeterRegistryAssert doesNotHaveMeterWithNameAndTags(String meterName, KeyValues tags) {
        return this.doesNotHaveMeterWithNameAndTags(meterName, this.toMicrometerTags(tags));
    }

    public MeterRegistryAssert doesNotHaveTimerWithNameAndTags(String timerName, KeyValues tags) {
        return this.doesNotHaveTimerWithNameAndTags(timerName, this.toMicrometerTags(tags));
    }

    public MeterRegistryAssert hasMeterWithNameAndTagKeys(String meterName, String ... tagKeys) {
        this.isNotNull();
        Meter foundMeter = ((MeterRegistry)this.actual).find(meterName).tagKeys(tagKeys).meter();
        if (foundMeter == null) {
            this.failWithMessage("Expected a meter with name <%s> and tag keys <%s> but found none.\nFound following metrics %s", new Object[]{meterName, String.join((CharSequence)",", tagKeys), this.allMetrics()});
        }
        return this;
    }

    public MeterRegistryAssert hasTimerWithNameAndTagKeys(String timerName, String ... tagKeys) {
        this.isNotNull();
        Timer foundTimer = ((MeterRegistry)this.actual).find(timerName).tagKeys(tagKeys).timer();
        if (foundTimer == null) {
            this.failWithMessage("Expected a timer with name <%s> and tag keys <%s> but found none.\nFound following metrics %s", new Object[]{timerName, String.join((CharSequence)",", tagKeys), this.allMetrics()});
        }
        return this;
    }

    public MeterRegistryAssert doesNotHaveMeterWithNameAndTagKeys(String meterName, String ... tagKeys) {
        this.isNotNull();
        Meter foundMeter = ((MeterRegistry)this.actual).find(meterName).tagKeys(tagKeys).meter();
        if (foundMeter != null) {
            this.failWithMessage("Expected no meter with name <%s> and tag keys <%s> but found one", new Object[]{meterName, String.join((CharSequence)",", tagKeys)});
        }
        return this;
    }

    public MeterRegistryAssert doesNotHaveTimerWithNameAndTagKeys(String timerName, String ... tagKeys) {
        this.isNotNull();
        Timer foundTimer = ((MeterRegistry)this.actual).find(timerName).tagKeys(tagKeys).timer();
        if (foundTimer != null) {
            this.failWithMessage("Expected no timer with name <%s> and tag keys <%s> but found one", new Object[]{timerName, String.join((CharSequence)",", tagKeys)});
        }
        return this;
    }

    private String allMetrics() {
        StringBuilder stringBuilder = new StringBuilder();
        ((MeterRegistry)this.actual).forEachMeter(meter -> stringBuilder.append("\n\tMeter with name <").append(meter.getId().getName()).append(">").append(" and type <").append(meter.getId().getType()).append(">").append(" \n\t\thas the following tags <").append(meter.getId().getTags()).append(">\n"));
        return stringBuilder.toString();
    }

    @CheckReturnValue
    public MeterAssert<?> meter(String meterName, Tag ... tags) {
        return this.meter(meterName, Arrays.asList(tags));
    }

    @CheckReturnValue
    public MeterAssert<?> meter(String meterName, Iterable<Tag> tags) {
        this.hasMeterWithName(meterName);
        Meter meter = ((MeterRegistry)this.actual).find(meterName).tags(tags).meter();
        ((ObjectAssert)Assertions.assertThat((Object)meter).as("Meter with name <%s> and tags <%s>", new Object[]{meterName, tags})).isNotNull();
        return MeterAssert.assertThat(meter);
    }

    @CheckReturnValue
    public CounterAssert counter(String name, Tag ... tags) {
        MeterAssert<?> meter = this.meter(name, tags).hasType(Counter.class);
        return (CounterAssert)((CounterAssert)((Object)CounterAssert.assertThat((Counter)meter.actual()).as("Counter with name <%s> and tags <%s>", new Object[]{name, tags}))).isNotNull();
    }

    @CheckReturnValue
    public TimerAssert timer(String name, Tag ... tags) {
        MeterAssert<?> meter = this.meter(name, tags).hasType(Timer.class);
        return (TimerAssert)((TimerAssert)((Object)TimerAssert.assertThat((Timer)meter.actual()).as("Timer with name <%s> and tags <%s>", new Object[]{name, tags}))).isNotNull();
    }

    @CheckReturnValue
    public GaugeAssert gauge(String name, Tag ... tags) {
        MeterAssert<?> meter = this.meter(name, tags).hasType(Gauge.class);
        return (GaugeAssert)((GaugeAssert)((Object)GaugeAssert.assertThat((Gauge)meter.actual()).as("Gauge with name <%s> and tags <%s>", new Object[]{name, tags}))).isNotNull();
    }
}

