/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.common.util.internal.logging;

import io.micrometer.common.util.internal.logging.FormattingTuple;
import io.micrometer.common.util.internal.logging.InternalLogLevel;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.LogEvent;
import io.micrometer.common.util.internal.logging.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jspecify.annotations.Nullable;

public class MockLogger
implements InternalLogger {
    private final String name;
    private final Queue<LogEvent> logEvents = new ConcurrentLinkedQueue<LogEvent>();

    MockLogger(String name) {
        this.name = name;
    }

    public List<LogEvent> getLogEvents() {
        return new ArrayList<LogEvent>(this.logEvents);
    }

    public void clear() {
        this.logEvents.clear();
    }

    public String name() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        this.log(InternalLogLevel.TRACE, msg);
    }

    public void trace(String format, @Nullable Object arg) {
        this.log(InternalLogLevel.TRACE, format, arg);
    }

    public void trace(String format, @Nullable Object argA, @Nullable Object argB) {
        this.log(InternalLogLevel.TRACE, format, argA, argB);
    }

    public void trace(String format, Object ... arguments) {
        this.log(InternalLogLevel.TRACE, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(InternalLogLevel.TRACE, msg, t);
    }

    public void trace(Throwable t) {
        this.log(InternalLogLevel.TRACE, t);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        this.log(InternalLogLevel.DEBUG, msg);
    }

    public void debug(String format, @Nullable Object arg) {
        this.log(InternalLogLevel.DEBUG, format, arg);
    }

    public void debug(String format, @Nullable Object argA, @Nullable Object argB) {
        this.log(InternalLogLevel.DEBUG, format, argA, argB);
    }

    public void debug(String format, Object ... arguments) {
        this.log(InternalLogLevel.DEBUG, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.log(InternalLogLevel.DEBUG, msg, t);
    }

    public void debug(Throwable t) {
        this.log(InternalLogLevel.DEBUG, t);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        this.log(InternalLogLevel.INFO, msg);
    }

    public void info(String format, @Nullable Object arg) {
        this.log(InternalLogLevel.INFO, format, arg);
    }

    public void info(String format, @Nullable Object argA, @Nullable Object argB) {
        this.log(InternalLogLevel.INFO, format, argA, argB);
    }

    public void info(String format, Object ... arguments) {
        this.log(InternalLogLevel.INFO, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.log(InternalLogLevel.INFO, msg, t);
    }

    public void info(Throwable t) {
        this.log(InternalLogLevel.INFO, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.log(InternalLogLevel.WARN, msg);
    }

    public void warn(String format, @Nullable Object arg) {
        this.log(InternalLogLevel.WARN, format, arg);
    }

    public void warn(String format, Object ... arguments) {
        this.log(InternalLogLevel.WARN, format, arguments);
    }

    public void warn(String format, @Nullable Object argA, @Nullable Object argB) {
        this.log(InternalLogLevel.WARN, format, argA, argB);
    }

    public void warn(String msg, Throwable t) {
        this.log(InternalLogLevel.WARN, msg, t);
    }

    public void warn(Throwable t) {
        this.log(InternalLogLevel.WARN, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.log(InternalLogLevel.ERROR, msg);
    }

    public void error(String format, @Nullable Object arg) {
        this.log(InternalLogLevel.ERROR, format, arg);
    }

    public void error(String format, @Nullable Object argA, @Nullable Object argB) {
        this.log(InternalLogLevel.ERROR, format, argA, argB);
    }

    public void error(String format, Object ... arguments) {
        this.log(InternalLogLevel.ERROR, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.log(InternalLogLevel.ERROR, msg, t);
    }

    public void error(Throwable t) {
        this.log(InternalLogLevel.ERROR, t);
    }

    public boolean isEnabled(InternalLogLevel level) {
        return true;
    }

    public void log(InternalLogLevel level, String msg) {
        this.log(level, msg, null);
    }

    public void log(InternalLogLevel level, String format, @Nullable Object arg) {
        this.log(level, MessageFormatter.format((String)format, (Object)arg));
    }

    public void log(InternalLogLevel level, String format, @Nullable Object argA, @Nullable Object argB) {
        this.log(level, MessageFormatter.format((String)format, (Object)argA, (Object)argB));
    }

    public void log(InternalLogLevel level, String format, Object ... arguments) {
        this.log(level, MessageFormatter.arrayFormat((String)format, (Object[])arguments));
    }

    private void log(InternalLogLevel level, FormattingTuple formattingTuple) {
        this.log(level, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    public void log(InternalLogLevel level, @Nullable String msg, @Nullable Throwable t) {
        this.logEvents.add(new LogEvent(level, msg, t));
    }

    public void log(InternalLogLevel level, Throwable t) {
        this.log(level, null, t);
    }
}

