/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web.client;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.Nullable;
import io.micrometer.spring.web.client.RestTemplateExchangeTagsProvider;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.core.NamedThreadLocal;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestExecution;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.web.util.UriTemplateHandler;

class MetricsClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor,
AsyncClientHttpRequestInterceptor {
    private static final ThreadLocal<String> urlTemplateHolder = new NamedThreadLocal("Rest Template URL Template");
    private final MeterRegistry meterRegistry;
    private final RestTemplateExchangeTagsProvider tagProvider;
    private final String metricName;

    MetricsClientHttpRequestInterceptor(MeterRegistry meterRegistry, String metricName, RestTemplateExchangeTagsProvider tagProvider) {
        this.tagProvider = tagProvider;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String urlTemplate = urlTemplateHolder.get();
        urlTemplateHolder.remove();
        Clock clock = this.meterRegistry.config().clock();
        long startTime = clock.monotonicTime();
        ClientHttpResponse response = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            this.getTimeBuilder(urlTemplate, request, response).register(this.meterRegistry).record(clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    public ListenableFuture<ClientHttpResponse> intercept(final HttpRequest request, byte[] body, AsyncClientHttpRequestExecution execution) throws IOException {
        ListenableFuture future;
        final String urlTemplate = urlTemplateHolder.get();
        urlTemplateHolder.remove();
        final Clock clock = this.meterRegistry.config().clock();
        final long startTime = clock.monotonicTime();
        try {
            future = execution.executeAsync(request, body);
        }
        catch (IOException e) {
            this.getTimeBuilder(urlTemplate, request, null).register(this.meterRegistry).record(clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            throw e;
        }
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<ClientHttpResponse>(){

            public void onSuccess(ClientHttpResponse response) {
                MetricsClientHttpRequestInterceptor.this.getTimeBuilder(urlTemplate, request, response).register(MetricsClientHttpRequestInterceptor.this.meterRegistry).record(clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            }

            public void onFailure(Throwable ex) {
                MetricsClientHttpRequestInterceptor.this.getTimeBuilder(urlTemplate, request, null).register(MetricsClientHttpRequestInterceptor.this.meterRegistry).record(clock.monotonicTime() - startTime, TimeUnit.NANOSECONDS);
            }
        });
        return future;
    }

    UriTemplateHandler createUriTemplateHandler(final UriTemplateHandler delegate) {
        return new UriTemplateHandler(){

            public URI expand(String url, Map<String, ?> arguments) {
                urlTemplateHolder.set(url);
                return delegate.expand(url, arguments);
            }

            public URI expand(String url, Object ... arguments) {
                urlTemplateHolder.set(url);
                return delegate.expand(url, arguments);
            }
        };
    }

    private Timer.Builder getTimeBuilder(@Nullable String urlTemplate, HttpRequest request, @Nullable ClientHttpResponse response) {
        return Timer.builder((String)this.metricName).tags(this.tagProvider.getTags(urlTemplate, request, response)).description("Timer of RestTemplate operation");
    }
}

