/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.hystrix.HystrixMetricsBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.micrometer.spring.autoconfigure.MeterRegistryPostProcessor;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.autoconfigure.PropertiesMeterFilter;
import io.micrometer.spring.integration.SpringIntegrationMetrics;
import io.micrometer.spring.scheduling.ScheduledMethodMetrics;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;

@Configuration
@ConditionalOnClass(value={Timed.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, RabbitAutoConfiguration.class, CacheAutoConfiguration.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @Bean
    public static MeterRegistryPostProcessor meterRegistryPostProcessor(ObjectProvider<List<MeterBinder>> meterBinders, ObjectProvider<List<MeterFilter>> meterFilters, ObjectProvider<List<MeterRegistryCustomizer<?>>> meterRegistryCustomizers, ObjectProvider<MetricsProperties> metricsProperties, ApplicationContext applicationContext) {
        return new MeterRegistryPostProcessor(meterBinders, meterFilters, meterRegistryCustomizers, metricsProperties, applicationContext);
    }

    @Bean
    @Order(value=0)
    public PropertiesMeterFilter propertiesMeterFilter(MetricsProperties properties) {
        return new PropertiesMeterFilter(properties);
    }

    @Bean
    @ConditionalOnClass(name={"com.netflix.hystrix.strategy.HystrixPlugins"})
    @ConditionalOnProperty(value={"management.metrics.binders.hystrix.enabled"}, matchIfMissing=true)
    public HystrixMetricsBinder hystrixMetricsBinder() {
        return new HystrixMetricsBinder();
    }

    @Configuration
    @ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
    @ConditionalOnProperty(value={"spring.aop.auto"}, havingValue="true", matchIfMissing=true)
    static class AopRequiredConfiguration {
        AopRequiredConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"management.metrics.binders.scheduled.enabled"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public ScheduledMethodMetrics metricsSchedulingAspect(MeterRegistry registry) {
            return new ScheduledMethodMetrics(registry);
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationManagement.class})
    static class MetricsIntegrationConfiguration {
        MetricsIntegrationConfiguration() {
        }

        @Bean(name={"integrationManagementConfigurer"})
        @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
        public IntegrationManagementConfigurer integrationManagementConfigurer() {
            IntegrationManagementConfigurer configurer = new IntegrationManagementConfigurer();
            configurer.setDefaultCountsEnabled(Boolean.valueOf(true));
            configurer.setDefaultStatsEnabled(Boolean.valueOf(true));
            return configurer;
        }

        @Bean
        public SpringIntegrationMetrics springIntegrationMetrics(IntegrationManagementConfigurer configurer) {
            return new SpringIntegrationMetrics(configurer);
        }
    }
}

