/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.web.client.MetricsClientHttpRequestInterceptor;
import io.micrometer.spring.web.client.RestTemplateExchangeTagsProvider;
import java.util.ArrayList;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class MetricsRestTemplateCustomizer
implements RestTemplateCustomizer {
    private final MetricsClientHttpRequestInterceptor interceptor;

    public MetricsRestTemplateCustomizer(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider tagProvider, String metricName, boolean recordPercentiles) {
        this.interceptor = new MetricsClientHttpRequestInterceptor(meterRegistry, tagProvider, metricName, recordPercentiles);
    }

    public void customize(RestTemplate restTemplate) {
        UriTemplateHandler templateHandler = restTemplate.getUriTemplateHandler();
        templateHandler = this.interceptor.createUriTemplateHandler(templateHandler);
        restTemplate.setUriTemplateHandler(templateHandler);
        ArrayList<MetricsClientHttpRequestInterceptor> interceptors = new ArrayList<MetricsClientHttpRequestInterceptor>();
        interceptors.add(this.interceptor);
        interceptors.addAll(restTemplate.getInterceptors());
        restTemplate.setInterceptors(interceptors);
    }
}

