/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.jdbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;

public class DataSourceMetrics
implements MeterBinder {
    private final String name;
    private final Iterable<Tag> tags;
    private final DataSourcePoolMetadata poolMetadata;
    private static Collection<DataSourcePoolMetadata> instrumentedPools = new ArrayList<DataSourcePoolMetadata>();

    public DataSourceMetrics(DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        DataSourcePoolMetadataProviders provider = new DataSourcePoolMetadataProviders(metadataProviders);
        this.poolMetadata = provider.getDataSourcePoolMetadata(dataSource);
        instrumentedPools.add(this.poolMetadata);
    }

    public void bindTo(MeterRegistry registry) {
        if (this.poolMetadata != null) {
            if (this.poolMetadata.getActive() != null) {
                registry.gauge(this.name + ".active.connections", this.tags, (Object)this.poolMetadata, DataSourcePoolMetadata::getActive);
            }
            if (this.poolMetadata.getMax() != null) {
                registry.gauge(this.name + ".max.connections", this.tags, (Object)this.poolMetadata, DataSourcePoolMetadata::getMax);
            }
            if (this.poolMetadata.getMin() != null) {
                registry.gauge(this.name + ".min.connections", this.tags, (Object)this.poolMetadata, DataSourcePoolMetadata::getMin);
            }
        }
    }
}

