/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.servlet;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.web.servlet.DefaultWebMvcTagsProvider;
import io.micrometer.spring.web.servlet.MetricsHandlerInterceptor;
import io.micrometer.spring.web.servlet.WebMvcMetrics;
import io.micrometer.spring.web.servlet.WebMvcTagsProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnClass(value={DispatcherServlet.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class WebMvcMetricsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WebMvcTagsProvider.class})
    public DefaultWebMvcTagsProvider webmvcTagConfigurer() {
        return new DefaultWebMvcTagsProvider();
    }

    @Bean
    public WebMvcMetrics controllerMetrics(MeterRegistry registry, MetricsProperties properties, WebMvcTagsProvider configurer) {
        return new WebMvcMetrics(registry, configurer, properties.getWeb().getServer().getRequestsMetricName(), properties.getWeb().getServer().isAutoTimeRequests(), properties.getWeb().getServer().isRecordRequestPercentiles());
    }

    @Bean
    public MetricsHandlerInterceptor webMetricsInterceptor(WebMvcMetrics controllerMetrics) {
        return new MetricsHandlerInterceptor(controllerMetrics);
    }

    @Configuration
    public class MetricsServletRequestInterceptorConfiguration
    extends WebMvcConfigurerAdapter {
        private final MetricsHandlerInterceptor handlerInterceptor;

        public MetricsServletRequestInterceptorConfiguration(MetricsHandlerInterceptor handlerInterceptor) {
            this.handlerInterceptor = handlerInterceptor;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor((HandlerInterceptor)this.handlerInterceptor);
        }
    }
}

