/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.web.client;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.web.client.DefaultRestTemplateExchangeTagsProvider;
import io.micrometer.spring.web.client.MetricsRestTemplateCustomizer;
import io.micrometer.spring.web.client.RestTemplateExchangeTagsProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
public class RestTemplateMetricsConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RestTemplateExchangeTagsProvider.class})
    public DefaultRestTemplateExchangeTagsProvider restTemplateTagConfigurer() {
        return new DefaultRestTemplateExchangeTagsProvider();
    }

    @Bean
    public MetricsRestTemplateCustomizer metricsRestTemplateCustomizer(MeterRegistry meterRegistry, RestTemplateExchangeTagsProvider restTemplateTagConfigurer, MetricsProperties properties) {
        return new MetricsRestTemplateCustomizer(meterRegistry, restTemplateTagConfigurer, properties.getWeb().getClient().getRequestsMetricName(), properties.getWeb().getClient().isRecordRequestPercentiles());
    }

    @Bean
    public static BeanPostProcessor restTemplateInterceptorPostProcessor(ApplicationContext applicationContext) {
        return new MetricsInterceptorPostProcessor(applicationContext);
    }

    private static class MetricsInterceptorPostProcessor
    implements BeanPostProcessor {
        private final ApplicationContext applicationContext;
        private MetricsRestTemplateCustomizer customizer;

        MetricsInterceptorPostProcessor(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof RestTemplate) {
                this.geCustomizer().customize((RestTemplate)bean);
            }
            return bean;
        }

        private MetricsRestTemplateCustomizer geCustomizer() {
            if (this.customizer == null) {
                this.customizer = (MetricsRestTemplateCustomizer)this.applicationContext.getBean(MetricsRestTemplateCustomizer.class);
            }
            return this.customizer;
        }
    }
}

