/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SimpleProperties.class})
public class SimpleExportConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.metrics.simple.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={MetricsExporter.class})
    public MetricsExporter simpleExporter(Clock clock) {
        return () -> new SimpleMeterRegistry(clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }
}

