/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.prometheus;

import io.micrometer.core.instrument.Clock;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusProperties;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusScrapeEndpoint;
import io.prometheus.client.CollectorRegistry;
import java.time.Duration;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={PrometheusMeterRegistry.class})
@EnableConfigurationProperties(value={PrometheusProperties.class})
public class PrometheusExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public PrometheusConfig prometheusConfig(PrometheusProperties props) {
        return new DefaultPrometheusConfig(props);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.prometheus.enabled"}, matchIfMissing=true)
    public MetricsExporter prometheusExporter(PrometheusConfig config, CollectorRegistry collectorRegistry, Clock clock) {
        return () -> new PrometheusMeterRegistry(config, collectorRegistry, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectorRegistry collectorRegistry() {
        return new CollectorRegistry(true);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @ManagementContextConfiguration
    public static class PrometheusScrapeEndpointConfiguration {
        @Bean
        public PrometheusScrapeEndpoint prometheusEndpoint(CollectorRegistry collectorRegistry) {
            return new PrometheusScrapeEndpoint(collectorRegistry);
        }
    }

    private class DefaultPrometheusConfig
    implements PrometheusConfig {
        private final PrometheusProperties props;
        private final PrometheusConfig defaults = k -> null;

        private DefaultPrometheusConfig(PrometheusProperties props) {
            this.props = props;
        }

        public String get(String k) {
            return null;
        }

        public boolean descriptions() {
            return this.props.getDescriptions() == null ? this.defaults.descriptions() : this.props.getDescriptions().booleanValue();
        }

        public Duration timerPercentilesMax() {
            return this.props.getTimerPercentilesMax();
        }

        public Duration timerPercentilesMin() {
            return this.props.getTimerPercentilesMin();
        }
    }
}

