/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.jmx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={JmxMeterRegistry.class})
public class JmxExportConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.metrics.jmx.enabled"}, matchIfMissing=true)
    public MetricsExporter jmxExporter(HierarchicalNameMapper nameMapper, Clock clock) {
        return () -> new JmxMeterRegistry(nameMapper, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

