/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.influx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.influx.InfluxConfig;
import io.micrometer.influx.InfluxConsistency;
import io.micrometer.influx.InfluxMeterRegistry;
import io.micrometer.spring.autoconfigure.export.DefaultStepRegistryConfig;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.influx.InfluxProperties;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={InfluxMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={InfluxProperties.class})
public class InfluxExportConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={InfluxConfig.class})
    public InfluxConfig influxConfig(InfluxProperties props) {
        return new DefaultInfluxConfig(props);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.influx.enabled"}, matchIfMissing=true)
    public MetricsExporter influxExporter(InfluxConfig config, Clock clock) {
        return () -> new InfluxMeterRegistry(config, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    private class DefaultInfluxConfig
    extends DefaultStepRegistryConfig
    implements InfluxConfig {
        private final InfluxProperties props;
        private final InfluxConfig defaults;

        public DefaultInfluxConfig(InfluxProperties props) {
            super(props);
            this.defaults = k -> null;
            this.props = props;
        }

        public String db() {
            return this.props.getDb() == null ? this.defaults.db() : this.props.getDb();
        }

        public InfluxConsistency consistency() {
            return this.props.getConsistency() == null ? this.defaults.consistency() : this.props.getConsistency();
        }

        public String userName() {
            return this.props.getUserName() == null ? this.defaults.userName() : this.props.getUserName();
        }

        public String password() {
            return this.props.getPassword() == null ? this.defaults.password() : this.props.getPassword();
        }

        public String retentionPolicy() {
            return this.props.getRetentionPolicy() == null ? this.defaults.retentionPolicy() : this.props.getRetentionPolicy();
        }

        public String uri() {
            return this.props.getUri() == null ? this.defaults.uri() : this.props.getUri();
        }

        public boolean compressed() {
            return this.props.getCompressed() == null ? this.defaults.compressed() : this.props.getCompressed().booleanValue();
        }

        public Duration timerPercentilesMax() {
            return this.props.getTimerPercentilesMax();
        }

        public Duration timerPercentilesMin() {
            return this.props.getTimerPercentilesMin();
        }
    }
}

