/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.graphite;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.graphite.GraphiteConfig;
import io.micrometer.graphite.GraphiteMeterRegistry;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.graphite.GraphiteProperties;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={GraphiteMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={GraphiteProperties.class})
public class GraphiteExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphiteConfig graphiteConfig(GraphiteProperties props) {
        return new DefaultGraphiteConfig(props);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.graphite.enabled"}, matchIfMissing=true)
    public MetricsExporter graphiteExporter(GraphiteConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        return () -> new GraphiteMeterRegistry(config, nameMapper, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }

    private class DefaultGraphiteConfig
    implements GraphiteConfig {
        private final GraphiteProperties props;
        private final GraphiteConfig defaults = k -> null;

        public DefaultGraphiteConfig(GraphiteProperties props) {
            this.props = props;
        }

        public String get(String k) {
            return null;
        }

        public boolean enabled() {
            return this.props.getEnabled();
        }

        public Duration step() {
            return this.props.getStep();
        }

        public TimeUnit rateUnits() {
            return this.props.getRateUnits() == null ? this.defaults.rateUnits() : this.props.getRateUnits();
        }

        public TimeUnit durationUnits() {
            return this.props.getDurationUnits() == null ? this.defaults.durationUnits() : this.props.getDurationUnits();
        }

        public String host() {
            return this.props.getHost() == null ? this.defaults.host() : this.props.getHost();
        }

        public int port() {
            return this.props.getPort() == null ? this.defaults.port() : this.props.getPort().intValue();
        }
    }
}

