/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.ganglia;

import info.ganglia.gmetric4j.gmetric.GMetric;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.ganglia.GangliaConfig;
import io.micrometer.ganglia.GangliaMeterRegistry;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.ganglia.GangliaProperties;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={GangliaMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={GangliaProperties.class})
public class GangliaExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GangliaConfig gangliaConfig(GangliaProperties props) {
        return new DefaultGangliaConfig(props);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.ganglia.enabled"}, matchIfMissing=true)
    public MetricsExporter gangliaExporter(GangliaConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        return () -> new GangliaMeterRegistry(config, nameMapper, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }

    private class DefaultGangliaConfig
    implements GangliaConfig {
        private final GangliaProperties props;
        private final GangliaConfig defaults = k -> null;

        private DefaultGangliaConfig(GangliaProperties props) {
            this.props = props;
        }

        public String get(String k) {
            return null;
        }

        public boolean enabled() {
            return this.props.getEnabled();
        }

        public Duration step() {
            return this.props.getStep();
        }

        public TimeUnit rateUnits() {
            return this.props.getRateUnits() == null ? this.defaults.rateUnits() : this.props.getRateUnits();
        }

        public TimeUnit durationUnits() {
            return this.props.getDurationUnits() == null ? this.defaults.durationUnits() : this.props.getDurationUnits();
        }

        public String protocolVersion() {
            return this.props.getProtocolVersion() == null ? this.defaults.protocolVersion() : this.props.getProtocolVersion();
        }

        public GMetric.UDPAddressingMode addressingMode() {
            return this.props.getAddressingMode() == null ? this.defaults.addressingMode() : this.props.getAddressingMode();
        }

        public int ttl() {
            return this.props.getTimeToLive() == null ? this.defaults.ttl() : this.props.getTimeToLive().intValue();
        }

        public String host() {
            return this.props.getHost() == null ? this.defaults.host() : this.props.getHost();
        }

        public int port() {
            return this.props.getPort() == null ? this.defaults.port() : this.props.getPort().intValue();
        }
    }
}

