/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.datadog;

import io.micrometer.core.instrument.Clock;
import io.micrometer.datadog.DatadogConfig;
import io.micrometer.datadog.DatadogMeterRegistry;
import io.micrometer.spring.autoconfigure.export.DefaultStepRegistryConfig;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.datadog.DatadogProperties;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={DatadogMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={DatadogProperties.class})
public class DatadogExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DatadogConfig datadogConfig(DatadogProperties props) {
        return new DefaultDatadogConfig(props);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.datadog.enabled"}, matchIfMissing=true)
    public MetricsExporter datadogExporter(DatadogConfig config, Clock clock) {
        return () -> new DatadogMeterRegistry(config, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    private class DefaultDatadogConfig
    extends DefaultStepRegistryConfig
    implements DatadogConfig {
        private final DatadogProperties props;
        private final DatadogConfig defaults;

        private DefaultDatadogConfig(DatadogProperties props) {
            super(props);
            this.defaults = k -> null;
            this.props = props;
        }

        public String apiKey() {
            return this.props.getApiKey();
        }

        public String hostTag() {
            return this.props.getHostKey() == null ? this.defaults.hostTag() : this.props.getHostKey();
        }

        public Duration timerPercentilesMax() {
            return this.props.getTimerPercentilesMax();
        }

        public Duration timerPercentilesMin() {
            return this.props.getTimerPercentilesMin();
        }
    }
}

