/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.atlas;

import com.netflix.spectator.atlas.AtlasConfig;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.spring.autoconfigure.export.DefaultStepRegistryConfig;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.atlas.AtlasProperties;
import java.time.Duration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={AtlasMeterRegistry.class})
@Import(value={StringToDurationConverter.class})
@EnableConfigurationProperties(value={AtlasProperties.class})
public class AtlasExportConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AtlasConfig.class})
    public AtlasConfig atlasConfig(AtlasProperties props) {
        return new DefaultAtlasConfig(props);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.atlas.enabled"}, matchIfMissing=true)
    public MetricsExporter atlasExporter(AtlasConfig config, Clock clock) {
        return () -> new AtlasMeterRegistry(config, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock clock() {
        return Clock.SYSTEM;
    }

    private class DefaultAtlasConfig
    extends DefaultStepRegistryConfig
    implements AtlasConfig {
        private final AtlasProperties props;
        private final AtlasConfig defaults;

        public DefaultAtlasConfig(AtlasProperties props) {
            super(props);
            this.defaults = k -> null;
            this.props = props;
        }

        public String uri() {
            return this.props.getUri() == null ? this.defaults.uri() : this.props.getUri();
        }

        public Duration meterTTL() {
            return this.props.getMeterTimeToLive() == null ? this.defaults.meterTTL() : this.props.getMeterTimeToLive();
        }

        public boolean lwcEnabled() {
            return this.props.getLwcEnabled() == null ? this.defaults.lwcEnabled() : this.props.getLwcEnabled().booleanValue();
        }

        public Duration configRefreshFrequency() {
            return this.props.getConfigRefreshFrequency() == null ? this.defaults.configRefreshFrequency() : this.props.getConfigRefreshFrequency();
        }

        public Duration configTTL() {
            return this.props.getConfigTimeToLive() == null ? this.defaults.configTTL() : this.props.getConfigTimeToLive();
        }

        public String configUri() {
            return this.props.getConfigUri() == null ? this.defaults.configUri() : this.props.getConfigUri();
        }

        public String evalUri() {
            return this.props.getEvalUri() == null ? this.defaults.evalUri() : this.props.getEvalUri();
        }
    }
}

