/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.spring.autoconfigure.MeterBindersConfiguration;
import io.micrometer.spring.autoconfigure.MeterRegistryConfigurer;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import io.micrometer.spring.autoconfigure.export.MetricsExporter;
import io.micrometer.spring.autoconfigure.export.atlas.AtlasExportConfiguration;
import io.micrometer.spring.autoconfigure.export.datadog.DatadogExportConfiguration;
import io.micrometer.spring.autoconfigure.export.ganglia.GangliaExportConfiguration;
import io.micrometer.spring.autoconfigure.export.graphite.GraphiteExportConfiguration;
import io.micrometer.spring.autoconfigure.export.influx.InfluxExportConfiguration;
import io.micrometer.spring.autoconfigure.export.jmx.JmxExportConfiguration;
import io.micrometer.spring.autoconfigure.export.prometheus.PrometheusExportConfiguration;
import io.micrometer.spring.autoconfigure.export.simple.SimpleExportConfiguration;
import io.micrometer.spring.autoconfigure.web.client.RestTemplateMetricsConfiguration;
import io.micrometer.spring.autoconfigure.web.servlet.WebMvcMetricsConfiguration;
import io.micrometer.spring.integration.SpringIntegrationMetrics;
import io.micrometer.spring.scheduling.ScheduledMethodMetrics;
import java.util.Collection;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;

@Configuration
@ConditionalOnClass(value={Timed.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
@Import(value={MeterBindersConfiguration.class, WebMvcMetricsConfiguration.class, RestTemplateMetricsConfiguration.class, AtlasExportConfiguration.class, DatadogExportConfiguration.class, GangliaExportConfiguration.class, GraphiteExportConfiguration.class, InfluxExportConfiguration.class, JmxExportConfiguration.class, PrometheusExportConfiguration.class, SimpleExportConfiguration.class})
public class MetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    public CompositeMeterRegistry compositeMeterRegistry(ObjectProvider<Collection<MetricsExporter>> exportersProvider) {
        CompositeMeterRegistry composite = new CompositeMeterRegistry();
        if (exportersProvider.getIfAvailable() != null) {
            ((Collection)exportersProvider.getIfAvailable()).forEach(exporter -> composite.add(exporter.registry()));
        }
        return composite;
    }

    @Bean
    @ConditionalOnClass(name={"org.aspectj.lang.ProceedingJoinPoint"})
    @ConditionalOnProperty(value={"spring.aop.enabled"}, havingValue="true", matchIfMissing=true)
    public ScheduledMethodMetrics metricsSchedulingAspect(MeterRegistry registry) {
        return new ScheduledMethodMetrics(registry);
    }

    @Configuration
    static class MeterRegistryConfigurationSupport {
        MeterRegistryConfigurationSupport(MeterRegistry registry, ObjectProvider<Collection<MeterRegistryConfigurer>> configurers, MetricsProperties config, ObjectProvider<Collection<MeterBinder>> binders) {
            if (configurers.getIfAvailable() != null) {
                ((Collection)configurers.getIfAvailable()).forEach(conf -> conf.configureRegistry(registry));
            }
            if (binders.getIfAvailable() != null) {
                ((Collection)binders.getIfAvailable()).forEach(binder -> binder.bindTo(registry));
            }
            if (config.isUseGlobalRegistry()) {
                Metrics.addRegistry((MeterRegistry)registry);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationManagement.class})
    static class MetricsIntegrationConfiguration {
        MetricsIntegrationConfiguration() {
        }

        @Bean(name={"integrationManagementConfigurer"})
        @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
        public IntegrationManagementConfigurer integrationManagementConfigurer() {
            IntegrationManagementConfigurer configurer = new IntegrationManagementConfigurer();
            configurer.setDefaultCountsEnabled(Boolean.valueOf(true));
            configurer.setDefaultStatsEnabled(Boolean.valueOf(true));
            return configurer;
        }

        @Bean
        public SpringIntegrationMetrics springIntegrationMetrics(IntegrationManagementConfigurer configurer) {
            return new SpringIntegrationMetrics(configurer);
        }
    }
}

