/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.lang.Nullable;
import java.util.Collections;
import java.util.List;

class WavefrontDistributionSummary
extends CumulativeDistributionSummary {
    @Nullable
    private final WavefrontHistogramImpl delegate;

    WavefrontDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id, clock, distributionStatisticConfig, scale, false);
        this.delegate = distributionStatisticConfig.isPublishingHistogram() ? new WavefrontHistogramImpl(() -> ((Clock)clock).wallTime()) : null;
    }

    protected void recordNonNegative(double amount) {
        super.recordNonNegative(amount);
        if (this.delegate != null) {
            this.delegate.update(amount);
        }
    }

    List<WavefrontHistogramImpl.Distribution> flushDistributions() {
        if (this.delegate == null) {
            return Collections.emptyList();
        }
        return this.delegate.flushDistributions();
    }

    boolean isPublishingHistogram() {
        return this.delegate != null;
    }
}

