/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.clients.WavefrontClient;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.histograms.WavefrontHistogramImpl;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.push.PushMeterRegistry;
import io.micrometer.core.instrument.push.PushRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import io.micrometer.core.ipc.http.HttpSender;
import io.micrometer.core.lang.Nullable;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontDistributionSummary;
import io.micrometer.wavefront.WavefrontLongTaskTimer;
import io.micrometer.wavefront.WavefrontNamingConvention;
import io.micrometer.wavefront.WavefrontTimer;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("waveferont-metrics-publisher");
    private final Logger logger = LoggerFactory.getLogger(WavefrontMeterRegistry.class);
    private final WavefrontConfig config;
    private final WavefrontSender wavefrontSender;
    private final Set<HistogramGranularity> histogramGranularities;

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock) {
        this(config, clock, DEFAULT_THREAD_FACTORY, (WavefrontSender)WavefrontMeterRegistry.getDefaultSenderBuilder(config).build());
    }

    @Deprecated
    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory) {
        this(config, clock, threadFactory, (WavefrontSender)WavefrontMeterRegistry.getDefaultSenderBuilder(config).build());
    }

    WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory, WavefrontSender wavefrontSender) {
        super((PushRegistryConfig)config, clock);
        this.config = config;
        this.wavefrontSender = wavefrontSender;
        this.histogramGranularities = new HashSet<HistogramGranularity>();
        if (config.reportMinuteDistribution()) {
            this.histogramGranularities.add(HistogramGranularity.MINUTE);
        }
        if (config.reportHourDistribution()) {
            this.histogramGranularities.add(HistogramGranularity.HOUR);
        }
        if (config.reportDayDistribution()) {
            this.histogramGranularities.add(HistogramGranularity.DAY);
        }
        this.config().namingConvention((NamingConvention)new WavefrontNamingConvention(config.globalPrefix()));
        this.start(threadFactory);
    }

    static boolean isDirectToApi(WavefrontConfig config) {
        return !"proxy".equals(URI.create(config.uri()).getScheme());
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        return new CumulativeCounter(id);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return new WavefrontLongTaskTimer(id, this.clock, distributionStatisticConfig, this.getBaseTimeUnit());
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        WavefrontTimer timer = new WavefrontTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit());
        if (!timer.isPublishingHistogram()) {
            HistogramGauges.registerWithCommonFormat((Timer)timer, (MeterRegistry)this);
        }
        return timer;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        WavefrontDistributionSummary summary = new WavefrontDistributionSummary(id, this.clock, distributionStatisticConfig, scale);
        if (!summary.isPublishingHistogram()) {
            HistogramGauges.registerWithCommonFormat((DistributionSummary)summary, (MeterRegistry)this);
        }
        return summary;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new CumulativeFunctionCounter(id, obj, countFunction);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected void publish() {
        this.getMeters().forEach(m -> m.use(this::publishMeter, this::publishMeter, this::publishTimer, this::publishSummary, this::publishLongTaskTimer, this::publishMeter, this::publishMeter, this::publishFunctionTimer, this::publishMeter));
    }

    private void publishFunctionTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        this.publishMetric(id, "count", wallTime, timer.count());
        this.publishMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
        this.publishMetric(id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
    }

    private void publishTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        WavefrontTimer wfTimer = (WavefrontTimer)timer;
        if (wfTimer.isPublishingHistogram()) {
            this.publishDistribution(id, wfTimer.flushDistributions());
        } else {
            this.publishMetric(id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
            this.publishMetric(id, "count", wallTime, timer.count());
            this.publishMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
            this.publishMetric(id, "max", wallTime, timer.max(this.getBaseTimeUnit()));
        }
    }

    private void publishLongTaskTimer(LongTaskTimer timer) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = timer.getId();
        WavefrontLongTaskTimer wfTimer = (WavefrontLongTaskTimer)timer;
        if (wfTimer.isPublishingHistogram()) {
            this.publishDistribution(id, wfTimer.flushDistributions());
        } else {
            this.publishMetric(id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
            this.publishMetric(id, "max", wallTime, timer.max(this.getBaseTimeUnit()));
        }
        this.publishMetric(id, "duration", wallTime, timer.duration(this.getBaseTimeUnit()));
        this.publishMetric(id, "active", wallTime, timer.activeTasks());
    }

    private void publishSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        Meter.Id id = summary.getId();
        WavefrontDistributionSummary wfSummary = (WavefrontDistributionSummary)summary;
        if (wfSummary.isPublishingHistogram()) {
            this.publishDistribution(id, wfSummary.flushDistributions());
        } else {
            this.publishMetric(id, "sum", wallTime, summary.totalAmount());
            this.publishMetric(id, "count", wallTime, summary.count());
            this.publishMetric(id, "avg", wallTime, summary.mean());
            this.publishMetric(id, "max", wallTime, summary.max());
        }
    }

    void publishMeter(Meter meter) {
        long wallTime = this.clock.wallTime();
        for (Measurement measurement : meter.measure()) {
            this.publishMetric(meter.getId().withTag(measurement.getStatistic()), null, wallTime, measurement.getValue());
        }
    }

    void publishMetric(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        if (!Double.isFinite(value)) {
            return;
        }
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        String name = this.getConventionName(fullId);
        String source = this.config.source();
        Map<String, String> tags = this.getTagsAsMap(id);
        try {
            this.wavefrontSender.sendMetric(name, value, Long.valueOf(wallTime), source, tags);
        }
        catch (IOException e) {
            this.logger.warn("failed to report metric to Wavefront: " + fullId.getName(), (Throwable)e);
        }
    }

    void publishDistribution(Meter.Id id, List<WavefrontHistogramImpl.Distribution> distributions) {
        String name = this.getConventionName(id);
        String source = this.config.source();
        Map<String, String> tags = this.getTagsAsMap(id);
        for (WavefrontHistogramImpl.Distribution distribution : distributions) {
            try {
                this.wavefrontSender.sendDistribution(name, distribution.centroids, this.histogramGranularities, Long.valueOf(distribution.timestamp), source, tags);
            }
            catch (IOException e) {
                this.logger.warn("failed to send distribution to Wavefront: " + id.getName(), (Throwable)e);
            }
        }
    }

    private Map<String, String> getTagsAsMap(Meter.Id id) {
        return this.getConventionTags(id).stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue, (tag1, tag2) -> tag2));
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return id.withName(id.getName() + "." + suffix);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    public void close() {
        super.close();
        try {
            this.wavefrontSender.close();
        }
        catch (IOException exception) {
            this.logger.warn("Unable to close Wavefront client", (Throwable)exception);
        }
    }

    static String getWavefrontReportingUri(WavefrontConfig wavefrontConfig) {
        if (!WavefrontMeterRegistry.isDirectToApi(wavefrontConfig)) {
            return "http" + wavefrontConfig.uri().substring("proxy".length());
        }
        return wavefrontConfig.uri();
    }

    public static WavefrontClient.Builder getDefaultSenderBuilder(WavefrontConfig config) {
        return new WavefrontClient.Builder(WavefrontMeterRegistry.getWavefrontReportingUri(config), config.apiToken()).batchSize(config.batchSize()).flushInterval((int)config.step().toMillis(), TimeUnit.MILLISECONDS);
    }

    public static Builder builder(WavefrontConfig config) {
        return new Builder(config);
    }

    static /* synthetic */ ThreadFactory access$000() {
        return DEFAULT_THREAD_FACTORY;
    }

    public static class Builder {
        private final WavefrontConfig config;
        private Clock clock = Clock.SYSTEM;
        private ThreadFactory threadFactory = WavefrontMeterRegistry.access$000();
        @Nullable
        private WavefrontSender wavefrontSender;

        Builder(WavefrontConfig config) {
            this.config = config;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        @Deprecated
        public Builder httpClient(HttpSender httpClient) {
            return this;
        }

        public Builder wavefrontSender(WavefrontSender wavefrontSender) {
            this.wavefrontSender = wavefrontSender;
            return this;
        }

        public WavefrontMeterRegistry build() {
            if (this.wavefrontSender == null) {
                this.config.validateSenderConfiguration().orThrow();
            }
            WavefrontSender sender = this.wavefrontSender != null ? this.wavefrontSender : WavefrontMeterRegistry.getDefaultSenderBuilder(this.config).build();
            return new WavefrontMeterRegistry(this.config, this.clock, this.threadFactory, sender);
        }
    }
}

