/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.datadog;

import io.micrometer.common.util.StringUtils;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import org.jspecify.annotations.Nullable;

public class DatadogNamingConvention
implements NamingConvention {
    private static final int MAX_NAME_LENGTH = 200;
    private final NamingConvention delegate;

    public DatadogNamingConvention() {
        this(NamingConvention.dot);
    }

    public DatadogNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String sanitized = StringEscapeUtils.escapeJson((String)this.delegate.name(name, type, baseUnit).replace('/', '_'));
        if (!Character.isLetter(sanitized.charAt(0))) {
            sanitized = "m." + sanitized;
        }
        return StringUtils.truncate((String)sanitized, (int)200);
    }

    public String tagKey(String key) {
        String sanitized = StringEscapeUtils.escapeJson((String)this.delegate.tagKey(key));
        if (Character.isDigit(sanitized.charAt(0))) {
            sanitized = "m." + sanitized;
        }
        return sanitized;
    }

    public String tagValue(String value) {
        return StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
    }
}

