/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.NullObservation;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.tck.InvalidObservationException;
import io.micrometer.observation.tck.TestObservationRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

class ObservationValidator
implements ObservationHandler<Observation.Context> {
    private final Consumer<ValidationResult> consumer = ObservationValidator::throwInvalidObservationException;
    private final Predicate<Observation.Context> supportsContextPredicate = context -> !(context instanceof NullObservation.NullContext);
    private final Map<String, Set<String>> lowCardinalityKeys = new HashMap<String, Set<String>>();
    private final Set<TestObservationRegistry.Capability> capabilities;

    ObservationValidator(Set<TestObservationRegistry.Capability> capabilities) {
        this.capabilities = capabilities;
    }

    public void onStart(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.START);
        Status status = (Status)context.get(Status.class);
        if (status != null) {
            this.consumer.accept(new ValidationResult("Invalid start: Observation '" + context.getName() + "' has already been started", context));
        } else {
            context.put(Status.class, (Object)new Status());
        }
    }

    public void onError(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.ERROR);
        this.checkIfObservationWasStartedButNotStopped("Invalid error signal", context);
    }

    public void onEvent(Observation.Event event, Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.EVENT);
        this.checkIfObservationWasStartedButNotStopped("Invalid event signal", context);
    }

    public void onScopeOpened(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.SCOPE_OPEN);
        this.checkIfObservationWasStarted("Invalid scope opening", context);
    }

    public void onScopeClosed(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.SCOPE_CLOSE);
        this.checkIfObservationWasStarted("Invalid scope closing", context);
    }

    public void onScopeReset(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.SCOPE_RESET);
        this.checkIfObservationWasStarted("Invalid scope resetting", context);
    }

    public void onStop(Observation.Context context) {
        this.addHistoryElement(context, InvalidObservationException.EventName.STOP);
        Status status = this.checkIfObservationWasStartedButNotStopped("Invalid stop", context);
        if (status != null) {
            status.markStopped();
        }
        if (this.capabilities.contains((Object)TestObservationRegistry.Capability.OBSERVATIONS_WITH_THE_SAME_NAME_SHOULD_HAVE_THE_SAME_SET_OF_LOW_CARDINALITY_KEYS)) {
            this.checkIfObservationsWithTheSameNameHaveTheSameSetOfLowCardinalityKeys(context);
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return this.supportsContextPredicate.test(context);
    }

    private void addHistoryElement(Observation.Context context, InvalidObservationException.EventName eventName) {
        History history = (History)context.computeIfAbsent(History.class, clazz -> new History());
        history.addHistoryElement(eventName);
    }

    private @Nullable Status checkIfObservationWasStarted(String prefix, Observation.Context context) {
        Status status = (Status)context.get(Status.class);
        if (status == null) {
            this.consumer.accept(new ValidationResult(prefix + ": Observation '" + context.getName() + "' has not been started yet", context));
        }
        return status;
    }

    private @Nullable Status checkIfObservationWasStartedButNotStopped(String prefix, Observation.Context context) {
        Status status = this.checkIfObservationWasStarted(prefix, context);
        if (status != null && status.isStopped()) {
            this.consumer.accept(new ValidationResult(prefix + ": Observation '" + context.getName() + "' has already been stopped", context));
        }
        return status;
    }

    private void checkIfObservationsWithTheSameNameHaveTheSameSetOfLowCardinalityKeys(Observation.Context context) {
        if (this.lowCardinalityKeys.containsKey(context.getName())) {
            Set<String> currentKeys;
            Set<String> existingKeys = this.lowCardinalityKeys.get(context.getName());
            if (!existingKeys.equals(currentKeys = this.getLowCardinalityKeys(context))) {
                String message = "Metrics backends may require that all observations with the same name have the same set of low cardinality keys. There is already an existing observation named '" + context.getName() + "' containing keys [" + String.join((CharSequence)", ", existingKeys) + "]. The observation you are attempting to register has keys [" + String.join((CharSequence)", ", currentKeys) + "].";
                throw new InvalidObservationException(message, context);
            }
        } else {
            this.lowCardinalityKeys.put(Objects.requireNonNull(context.getName()), this.getLowCardinalityKeys(context));
        }
    }

    private Set<String> getLowCardinalityKeys(Observation.Context context) {
        return this.getKeys(context.getLowCardinalityKeyValues());
    }

    private Set<String> getKeys(KeyValues keyValues) {
        return keyValues.stream().map(KeyValue::getKey).collect(Collectors.toSet());
    }

    private static void throwInvalidObservationException(ValidationResult validationResult) {
        History history = (History)validationResult.getContext().getOrDefault(History.class, History::new);
        throw new InvalidObservationException(validationResult.getMessage(), validationResult.getContext(), history.getHistoryElements());
    }

    static class Status {
        private boolean stopped = false;

        Status() {
        }

        boolean isStopped() {
            return this.stopped;
        }

        void markStopped() {
            this.stopped = true;
        }
    }

    static class ValidationResult {
        private final String message;
        private final Observation.Context context;

        ValidationResult(String message, Observation.Context context) {
            this.message = message;
            this.context = context;
        }

        String getMessage() {
            return this.message;
        }

        Observation.Context getContext() {
            return this.context;
        }

        public String toString() {
            return this.getMessage() + " - " + this.getContext();
        }
    }

    static class History {
        private final List<InvalidObservationException.HistoryElement> historyElements = new ArrayList<InvalidObservationException.HistoryElement>();

        History() {
        }

        private void addHistoryElement(InvalidObservationException.EventName eventName) {
            this.historyElements.add(new InvalidObservationException.HistoryElement(eventName));
        }

        List<InvalidObservationException.HistoryElement> getHistoryElements() {
            return Collections.unmodifiableList(this.historyElements);
        }
    }
}

