/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.tck.ObservationValidator;
import io.micrometer.observation.tck.TestObservationRegistryAssert;
import java.util.HashSet;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.assertj.core.api.AssertProvider;
import org.jspecify.annotations.Nullable;

public final class TestObservationRegistry
implements ObservationRegistry,
AssertProvider<TestObservationRegistryAssert> {
    private final ObservationRegistry delegate = ObservationRegistry.create();
    private final StoringObservationHandler handler = new StoringObservationHandler();

    private TestObservationRegistry() {
        this.observationConfig().observationHandler((ObservationHandler)this.handler).observationHandler((ObservationHandler)new ObservationValidator());
    }

    public static TestObservationRegistry create() {
        return new TestObservationRegistry();
    }

    public @Nullable Observation getCurrentObservation() {
        return this.delegate.getCurrentObservation();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Observation.Scope getCurrentObservationScope() {
        return this.delegate.getCurrentObservationScope();
    }

    public void setCurrentObservationScope(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Observation.Scope current) {
        this.delegate.setCurrentObservationScope(current);
    }

    public ObservationRegistry.ObservationConfig observationConfig() {
        return this.delegate.observationConfig();
    }

    Queue<TestObservationContext> getContexts() {
        return this.handler.contexts;
    }

    public void clear() {
        this.getContexts().clear();
    }

    @Deprecated
    public TestObservationRegistryAssert assertThat() {
        return TestObservationRegistryAssert.assertThat(this);
    }

    private static class StoringObservationHandler
    implements ObservationHandler<Observation.Context> {
        final Queue<TestObservationContext> contexts = new ConcurrentLinkedQueue<TestObservationContext>();

        private StoringObservationHandler() {
        }

        public void onStart(Observation.Context context) {
            this.contexts.add(new TestObservationContext(context).setObservationStarted(true));
        }

        public void onStop(Observation.Context context) {
            this.contexts.stream().filter(testContext -> testContext.getContext() == context).findFirst().ifPresent(testContext -> testContext.setObservationStopped(true));
        }

        public boolean supportsContext(Observation.Context context) {
            return true;
        }

        public void onEvent(Observation.Event event, Observation.Context context) {
            this.contexts.stream().filter(testContext -> testContext.getContext() == context).findFirst().ifPresent(testContext -> testContext.addEvent(event));
        }
    }

    static class TestObservationContext {
        private final Observation.Context context;
        private boolean observationStarted;
        private boolean observationStopped;
        private final Set<Observation.Event> contextEvents = new HashSet<Observation.Event>();

        TestObservationContext(Observation.Context context) {
            this.context = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestObservationContext)) {
                return false;
            }
            TestObservationContext that = (TestObservationContext)o;
            return Objects.equals(this.context, that.context);
        }

        public int hashCode() {
            return Objects.hash(this.context);
        }

        TestObservationContext setObservationStarted(boolean observationStarted) {
            this.observationStarted = observationStarted;
            return this;
        }

        TestObservationContext setObservationStopped(boolean observationStopped) {
            this.observationStopped = observationStopped;
            return this;
        }

        boolean isObservationStarted() {
            return this.observationStarted;
        }

        boolean isObservationStopped() {
            return this.observationStopped;
        }

        Observation.Context getContext() {
            return this.context;
        }

        void addEvent(Observation.Event event) {
            this.contextEvents.add(event);
        }

        boolean hasEvent(String name) {
            return this.contextEvents.stream().anyMatch(event -> event.getName().equals(name));
        }

        boolean hasEvent(String name, String contextualName) {
            return this.contextEvents.stream().anyMatch(event -> event.getName().equals(name) && event.getContextualName().equals(contextualName));
        }
    }
}

