/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.assertj.core.api.AbstractAssert;

public class ObservationRegistryAssert<SELF extends ObservationRegistryAssert<SELF, ACTUAL>, ACTUAL extends ObservationRegistry>
extends AbstractAssert<SELF, ACTUAL> {
    protected ObservationRegistryAssert(ACTUAL actual) {
        super(actual, ObservationRegistryAssert.class);
    }

    protected ObservationRegistryAssert(ACTUAL actual, Class<SELF> clazz) {
        super(actual, clazz);
    }

    public static ObservationRegistryAssert assertThat(ObservationRegistry actual) {
        return new ObservationRegistryAssert(actual);
    }

    public static ObservationRegistryAssert then(ObservationRegistry actual) {
        return new ObservationRegistryAssert(actual);
    }

    public SELF doesNotHaveAnyRemainingCurrentObservation() {
        this.isNotNull();
        Observation current = ((ObservationRegistry)this.actual).getCurrentObservation();
        if (current != null) {
            this.failWithMessage("Expected no current observation in the registry but found one", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF hasRemainingCurrentObservation() {
        this.isNotNull();
        Observation current = ((ObservationRegistry)this.actual).getCurrentObservation();
        if (current == null) {
            this.failWithMessage("Expected an observation in the registry but found none", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveRemainingCurrentObservationSameAs(Observation observation) {
        this.isNotNull();
        Observation current = ((ObservationRegistry)this.actual).getCurrentObservation();
        if (current == observation) {
            this.failWithMessage("Expected current observation in the registry to be different than <%s> but was the same", new Object[]{observation});
        }
        return (SELF)((Object)this);
    }

    public SELF hasRemainingCurrentObservationSameAs(Observation observation) {
        this.isNotNull();
        Observation current = ((ObservationRegistry)this.actual).getCurrentObservation();
        if (current == null) {
            this.failWithMessage("Expected current observation in the registry to be same as <%s> but there was no current observation", new Object[]{observation});
        }
        if (current != observation) {
            this.failWithActualExpectedAndMessage(current, observation, "Expected current observation in the registry to be same as <%s> but was <%s>", new Object[]{observation, current});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveAnyRemainingCurrentScope() {
        this.isNotNull();
        Observation.Scope current = ((ObservationRegistry)this.actual).getCurrentObservationScope();
        if (current != null) {
            this.failWithMessage("Expected no current Scope in the registry but found one tied to observation named <%s>", new Object[]{current.getCurrentObservation().getContext().getName()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasRemainingCurrentScope() {
        this.isNotNull();
        Observation.Scope current = ((ObservationRegistry)this.actual).getCurrentObservationScope();
        if (current == null) {
            this.failWithMessage("Expected a current Scope in the registry but found none", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveRemainingCurrentScopeSameAs(Observation.Scope scope) {
        this.isNotNull();
        Observation.Scope current = ((ObservationRegistry)this.actual).getCurrentObservationScope();
        if (current == scope) {
            this.failWithMessage("Expected current Scope in the registry to be different from a provided Scope tied to observation named <%s> but was the same", new Object[]{scope.getCurrentObservation().getContext().getName()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasRemainingCurrentScopeSameAs(Observation.Scope scope) {
        this.isNotNull();
        Observation.Scope current = ((ObservationRegistry)this.actual).getCurrentObservationScope();
        String expectedContextName = scope.getCurrentObservation().getContext().getName();
        if (current == null) {
            this.failWithMessage("Expected current Scope in the registry to be same as a provided Scope tied to observation named <%s> but there was no current scope", new Object[]{expectedContextName});
        }
        if (current != scope) {
            String actualContextName = current.getCurrentObservation().getContext().getName();
            this.failWithActualExpectedAndMessage(actualContextName, expectedContextName, "Expected current Scope in the registry to be same as a provided Scope tied to observation named <%s> but was a different one (tied to observation named <%s>)", new Object[]{expectedContextName, actualContextName});
        }
        return (SELF)((Object)this);
    }
}

