/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationView;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.util.Streams;

public class ObservationContextAssert<SELF extends ObservationContextAssert<SELF>>
extends AbstractAssert<SELF, Observation.ContextView> {
    protected ObservationContextAssert(Observation.ContextView actual) {
        super((Object)actual, ObservationContextAssert.class);
    }

    public static ObservationContextAssert<?> assertThat(Observation.ContextView actual) {
        return new ObservationContextAssert(actual);
    }

    public static ObservationContextAssert<?> then(Observation.ContextView actual) {
        return new ObservationContextAssert(actual);
    }

    public SELF hasNameEqualTo(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getName();
        if (!Objects.equals(name, actualName)) {
            this.failWithMessage("Observation should have name equal to <%s> but has <%s>", new Object[]{name, actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveNameEqualTo(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getName();
        if (Objects.equals(name, actualName)) {
            this.failWithMessage("Observation should not have name equal to <%s>", new Object[]{actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF hasNameEqualToIgnoringCase(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getName();
        if (!name.equalsIgnoreCase(actualName)) {
            this.failWithMessage("Observation should have name equal to ignoring case <%s> but has <%s>", new Object[]{name, actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveNameEqualToIgnoringCase(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getName();
        if (name.equalsIgnoreCase(actualName)) {
            this.failWithMessage("Observation should not have name equal to ignoring case <%s>", new Object[]{actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF hasContextualNameEqualTo(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getContextualName();
        if (!Objects.equals(name, actualName)) {
            this.failWithMessage("Observation should have contextual name equal to <%s> but has <%s>", new Object[]{name, actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveContextualNameEqualTo(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getContextualName();
        if (name.equals(actualName)) {
            this.failWithMessage("Observation should not have contextual name equal to <%s>", new Object[]{actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF hasContextualNameEqualToIgnoringCase(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getContextualName();
        if (!name.equalsIgnoreCase(actualName)) {
            this.failWithMessage("Observation should have contextual name equal to ignoring case <%s> but has <%s>", new Object[]{name, actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveContextualNameEqualToIgnoringCase(String name) {
        this.isNotNull();
        String actualName = ((Observation.ContextView)this.actual).getContextualName();
        if (name.equalsIgnoreCase(actualName)) {
            this.failWithMessage("Observation should not have contextual name equal to ignoring case <%s>", new Object[]{actualName});
        }
        return (SELF)((Object)this);
    }

    public SELF hasNoKeyValues() {
        this.isNotNull();
        KeyValues tags = ((Observation.ContextView)this.actual).getAllKeyValues();
        if (tags.stream().findAny().isPresent()) {
            this.failWithMessage("Observation should have no tags but has <%s>", new Object[]{tags});
        }
        return (SELF)((Object)this);
    }

    public SELF hasAnyKeyValues() {
        this.isNotNull();
        KeyValues tags = ((Observation.ContextView)this.actual).getAllKeyValues();
        if (!tags.stream().findAny().isPresent()) {
            this.failWithMessage("Observation should have any tags but has none", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF hasKeyValuesCount(int size) {
        this.isNotNull();
        long actualSize = ((Observation.ContextView)this.actual).getAllKeyValues().stream().count();
        if (actualSize != (long)size) {
            this.failWithMessage("Observation expected to have <%s> keys but has <%s>.", new Object[]{size, actualSize});
        }
        return (SELF)((Object)this);
    }

    private List<String> allKeys() {
        List<String> result = this.lowCardinalityKeys();
        result.addAll(this.highCardinalityKeys());
        return result;
    }

    public SELF hasOnlyKeys(String ... keys) {
        boolean sameContent;
        this.isNotNull();
        LinkedHashSet<String> actualKeys = new LinkedHashSet<String>(this.allKeys());
        List<String> expectedKeys = Arrays.asList(keys);
        boolean bl = sameContent = actualKeys.containsAll(expectedKeys) && actualKeys.size() == expectedKeys.size();
        if (!sameContent) {
            LinkedHashSet<String> extraKeys = new LinkedHashSet<String>(actualKeys);
            extraKeys.removeAll(expectedKeys);
            LinkedHashSet<String> missingKeys = new LinkedHashSet<String>(expectedKeys);
            missingKeys.removeAll(actualKeys);
            if (!extraKeys.isEmpty() && !missingKeys.isEmpty()) {
                this.failWithMessage("Observation has unexpected keys %s and misses expected keys %s.", new Object[]{extraKeys, missingKeys});
            } else if (!extraKeys.isEmpty()) {
                this.failWithMessage("Observation has unexpected keys %s.", new Object[]{extraKeys});
            } else {
                this.failWithMessage("Observation is missing expected keys %s.", new Object[]{missingKeys});
            }
        }
        return (SELF)((Object)this);
    }

    public SELF hasSubsetOfKeys(String ... keys) {
        this.isNotNull();
        LinkedHashSet<String> actualKeys = new LinkedHashSet<String>(this.allKeys());
        LinkedHashSet<String> expectedKeys = new LinkedHashSet<String>(Arrays.asList(keys));
        List extra = Streams.stream(actualKeys).filter(actualElement -> !expectedKeys.contains(actualElement)).collect(Collectors.toList());
        if (extra.size() > 0) {
            this.failWithMessage("Observation keys are not a subset of %s. Found extra keys: %s", new Object[]{expectedKeys, extra});
        }
        return (SELF)((Object)this);
    }

    private List<String> lowCardinalityKeys() {
        return ((Observation.ContextView)this.actual).getLowCardinalityKeyValues().stream().map(KeyValue::getKey).collect(Collectors.toList());
    }

    private List<String> highCardinalityKeys() {
        return ((Observation.ContextView)this.actual).getHighCardinalityKeyValues().stream().map(KeyValue::getKey).collect(Collectors.toList());
    }

    public SELF hasLowCardinalityKeyValueWithKey(String key) {
        this.isNotNull();
        if (((Observation.ContextView)this.actual).getLowCardinalityKeyValues().stream().noneMatch(tag -> tag.getKey().equals(key))) {
            this.failWithMessage("Observation should have a low cardinality tag with key <%s> but it's not there. List of all keys <%s>", new Object[]{key, this.lowCardinalityKeys()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasLowCardinalityKeyValue(String key, String value) {
        this.isNotNull();
        this.hasLowCardinalityKeyValueWithKey(key);
        String tagValue = ((Observation.ContextView)this.actual).getLowCardinalityKeyValues().stream().filter(tag -> tag.getKey().equals(key)).findFirst().get().getValue();
        if (!Objects.equals(tagValue, value)) {
            this.failWithMessage("Observation should have a low cardinality tag with key <%s> and value <%s>. The key is correct but the value is <%s>", new Object[]{key, value, tagValue});
        }
        return (SELF)((Object)this);
    }

    public SELF hasLowCardinalityKeyValue(KeyValue keyValue) {
        return this.hasLowCardinalityKeyValue(keyValue.getKey(), keyValue.getValue());
    }

    public SELF doesNotHaveLowCardinalityKeyValueWithKey(String key) {
        this.isNotNull();
        if (((Observation.ContextView)this.actual).getLowCardinalityKeyValues().stream().anyMatch(tag -> tag.getKey().equals(key))) {
            this.failWithMessage("Observation should not have a low cardinality tag with key <%s>", new Object[]{key});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveLowCardinalityKeyValue(String key, String value) {
        this.isNotNull();
        Optional<KeyValue> optional = ((Observation.ContextView)this.actual).getLowCardinalityKeyValues().stream().filter(tag -> tag.getKey().equals(key)).findFirst();
        if (!optional.isPresent()) {
            return (SELF)((Object)this);
        }
        String tagValue = optional.get().getValue();
        if (Objects.equals(tagValue, value)) {
            this.failWithMessage("Observation should not have a low cardinality tag with key <%s> and value <%s>", new Object[]{key, value});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveLowCardinalityKeyValue(KeyValue keyValue) {
        return this.doesNotHaveLowCardinalityKeyValue(keyValue.getKey(), keyValue.getValue());
    }

    public SELF hasHighCardinalityKeyValueWithKey(String key) {
        this.isNotNull();
        if (((Observation.ContextView)this.actual).getHighCardinalityKeyValues().stream().noneMatch(tag -> tag.getKey().equals(key))) {
            this.failWithMessage("Observation should have a high cardinality tag with key <%s> but it's not there. List of all keys <%s>", new Object[]{key, this.highCardinalityKeys()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasHighCardinalityKeyValue(String key, String value) {
        this.isNotNull();
        this.hasHighCardinalityKeyValueWithKey(key);
        String tagValue = ((Observation.ContextView)this.actual).getHighCardinalityKeyValues().stream().filter(tag -> tag.getKey().equals(key)).findFirst().get().getValue();
        if (!Objects.equals(tagValue, value)) {
            this.failWithMessage("Observation should have a high cardinality tag with key <%s> and value <%s>. The key is correct but the value is <%s>", new Object[]{key, value, tagValue});
        }
        return (SELF)((Object)this);
    }

    public SELF hasHighCardinalityKeyValue(KeyValue keyValue) {
        return this.hasHighCardinalityKeyValue(keyValue.getKey(), keyValue.getValue());
    }

    public SELF doesNotHaveHighCardinalityKeyValueWithKey(String key) {
        this.isNotNull();
        if (((Observation.ContextView)this.actual).getHighCardinalityKeyValues().stream().anyMatch(tag -> tag.getKey().equals(key))) {
            this.failWithMessage("Observation should not have a high cardinality tag with key <%s>", new Object[]{key});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveHighCardinalityKeyValue(String key, String value) {
        this.isNotNull();
        Optional<KeyValue> optional = ((Observation.ContextView)this.actual).getHighCardinalityKeyValues().stream().filter(tag -> tag.getKey().equals(key)).findFirst();
        if (!optional.isPresent()) {
            return (SELF)((Object)this);
        }
        String tagValue = optional.get().getValue();
        if (tagValue.equals(value)) {
            this.failWithMessage("Observation should not have a high cardinality tag with key <%s> and value <%s>", new Object[]{key, value});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveHighCardinalityKeyValue(KeyValue keyValue) {
        return this.doesNotHaveHighCardinalityKeyValue(keyValue.getKey(), keyValue.getValue());
    }

    public SELF hasMapEntry(Object key, Object value) {
        this.isNotNull();
        Object mapValue = ((Observation.ContextView)this.actual).get(key);
        if (!Objects.equals(mapValue, value)) {
            this.failWithMessage("Observation should have an entry for key <%s> with value <%s>. Value was <%s>", new Object[]{key, value, mapValue});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveMapEntry(Object key, Object value) {
        this.isNotNull();
        Object mapValue = ((Observation.ContextView)this.actual).get(key);
        if (Objects.equals(mapValue, value)) {
            this.failWithMessage("Observation should not have an entry for key <%s> with value <%s>", new Object[]{key, value, mapValue});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveError() {
        ((ObservationContextAssertReturningThrowableAssert)this.thenError().withFailMessage("Observation should not have an error, but found <%s>", new Object[]{((Observation.ContextView)this.actual).getError()})).isNull();
        return (SELF)((Object)this);
    }

    public SELF hasError() {
        ((ObservationContextAssertReturningThrowableAssert)this.thenError().withFailMessage("Observation should have an error, but none was found", new Object[0])).isNotNull();
        return (SELF)((Object)this);
    }

    public SELF hasError(Throwable expectedError) {
        this.hasError();
        ((ObservationContextAssertReturningThrowableAssert)this.thenError().withFailMessage("Observation expected to have error <%s>, but has <%s>", new Object[]{expectedError, ((Observation.ContextView)this.actual).getError()})).isEqualTo(expectedError);
        return (SELF)((Object)this);
    }

    public ObservationContextAssertReturningThrowableAssert assertThatError() {
        return new ObservationContextAssertReturningThrowableAssert(((Observation.ContextView)this.actual).getError(), this);
    }

    public ObservationContextAssertReturningThrowableAssert thenError() {
        return this.assertThatError();
    }

    public SELF hasParentObservation() {
        this.isNotNull();
        if (((Observation.ContextView)this.actual).getParentObservation() == null) {
            this.failWithMessage("Observation should have a parent", new Object[0]);
        }
        return (SELF)((Object)this);
    }

    private ObservationView checkedParentObservation() {
        this.isNotNull();
        ObservationView p = ((Observation.ContextView)this.actual).getParentObservation();
        if (p == null) {
            this.failWithMessage("Observation should have a parent", new Object[0]);
        }
        return p;
    }

    public SELF hasParentObservationEqualTo(Observation expectedParent) {
        this.isNotNull();
        ObservationView realParent = ((Observation.ContextView)this.actual).getParentObservation();
        if (realParent == null) {
            this.failWithMessage("Observation should have parent <%s> but has none", new Object[]{expectedParent});
        }
        if (!realParent.equals((Object)expectedParent)) {
            this.failWithMessage("Observation should have parent <%s> but has <%s>", new Object[]{expectedParent, realParent});
        }
        return (SELF)((Object)this);
    }

    public SELF doesNotHaveParentObservation() {
        this.isNotNull();
        if (((Observation.ContextView)this.actual).getParentObservation() != null) {
            this.failWithMessage("Observation should not have a parent but has <%s>", new Object[]{((Observation.ContextView)this.actual).getParentObservation()});
        }
        return (SELF)((Object)this);
    }

    public SELF hasParentObservationContextSatisfying(ThrowingConsumer<Observation.ContextView> parentContextViewAssertion) {
        ObservationView p = this.checkedParentObservation();
        try {
            parentContextViewAssertion.accept((Object)p.getContextView());
        }
        catch (Throwable e) {
            this.failWithMessage("Parent observation does not satisfy given assertion: " + e.getMessage(), new Object[0]);
        }
        return (SELF)((Object)this);
    }

    public SELF hasParentObservationContextMatching(Predicate<? super Observation.ContextView> parentContextViewPredicate) {
        ObservationView p = this.checkedParentObservation();
        if (!parentContextViewPredicate.test((Observation.ContextView)p.getContextView())) {
            this.failWithMessage("Observation should have parent that matches given predicate but <%s> didn't", new Object[]{p});
        }
        return (SELF)((Object)this);
    }

    public SELF hasParentObservationContextMatching(Predicate<? super Observation.ContextView> parentContextViewPredicate, String description) {
        ObservationView p = this.checkedParentObservation();
        if (!parentContextViewPredicate.test((Observation.ContextView)p.getContextView())) {
            this.failWithMessage("Observation should have parent that matches '%s' predicate but <%s> didn't", new Object[]{description, p});
        }
        return (SELF)((Object)this);
    }

    public static class ObservationContextAssertReturningThrowableAssert
    extends AbstractThrowableAssert<ObservationContextAssertReturningThrowableAssert, Throwable> {
        private final ObservationContextAssert observationContextAssert;

        public ObservationContextAssertReturningThrowableAssert(Throwable throwable, ObservationContextAssert observationContextAssert) {
            super(throwable, ObservationContextAssertReturningThrowableAssert.class);
            this.observationContextAssert = observationContextAssert;
        }

        public ObservationContextAssert backToContext() {
            return this.observationContextAssert;
        }
    }
}

