/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.jersey2.server;

import io.micrometer.core.instrument.Tag;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.uri.UriTemplate;

public final class DefaultJerseyTagsProvider
implements JerseyTagsProvider {
    static final String TAG_METHOD = "method";
    static final String TAG_URI = "uri";
    static final String TAG_STATUS = "status";
    static final String TAG_EXCEPTION = "exception";

    @Override
    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        int statusCode = DefaultJerseyTagsProvider.statusCode(event);
        return Arrays.asList(DefaultJerseyTagsProvider.method(event), DefaultJerseyTagsProvider.uri(event, statusCode), DefaultJerseyTagsProvider.status(statusCode), DefaultJerseyTagsProvider.exception(event, statusCode));
    }

    @Override
    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        return Arrays.asList(DefaultJerseyTagsProvider.method(event), DefaultJerseyTagsProvider.uri(event, 0));
    }

    private static Tag method(RequestEvent event) {
        String httpMethod = event.getContainerRequest().getMethod();
        return Tag.of((String)TAG_METHOD, (String)httpMethod);
    }

    private static Tag uri(RequestEvent event, int statusCode) {
        String uri = statusCode == 404 ? "NOT_FOUND" : (DefaultJerseyTagsProvider.isRedirect(statusCode) ? "REDIRECTION" : DefaultJerseyTagsProvider.templatedUri(event));
        return Tag.of((String)TAG_URI, (String)uri);
    }

    private static Tag status(int statusCode) {
        return Tag.of((String)TAG_STATUS, (String)Integer.valueOf(statusCode).toString());
    }

    private static Tag exception(RequestEvent event, int statusCode) {
        Throwable exception = event.getException();
        if (exception != null && statusCode != 404 && !DefaultJerseyTagsProvider.isRedirect(statusCode)) {
            Throwable cause = exception.getCause() != null ? exception.getCause() : exception;
            return Tag.of((String)TAG_EXCEPTION, (String)cause.getClass().getSimpleName());
        }
        return Tag.of((String)TAG_EXCEPTION, (String)"None");
    }

    private static int statusCode(RequestEvent event) {
        ContainerResponse containerResponse = event.getContainerResponse();
        if (containerResponse != null) {
            return containerResponse.getStatus();
        }
        return Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    }

    private static boolean isRedirect(int status) {
        return Response.Status.Family.REDIRECTION.equals((Object)Response.Status.Family.familyOf((int)status));
    }

    private static String templatedUri(RequestEvent event) {
        ExtendedUriInfo uriInfo = event.getUriInfo();
        ArrayList matchedTemplates = new ArrayList(uriInfo.getMatchedTemplates());
        if (matchedTemplates.size() > 1) {
            Collections.reverse(matchedTemplates);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uriInfo.getBaseUri().getPath());
        for (UriTemplate uriTemplate : matchedTemplates) {
            sb.append(uriTemplate.getTemplate());
        }
        return sb.toString().replaceAll("//+", "/");
    }
}

