/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.kafka;

import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

@NonNullApi
@NonNullFields
@Incubating(since="1.4.0")
class KafkaMetrics
implements MeterBinder,
AutoCloseable {
    static final String METRIC_NAME_PREFIX = "kafka.";
    static final String METRIC_GROUP_APP_INFO = "app-info";
    static final String METRIC_GROUP_METRICS_COUNT = "kafka-metrics-count";
    static final String VERSION_METRIC_NAME = "version";
    static final String START_TIME_METRIC_NAME = "start-time-ms";
    static final Duration DEFAULT_REFRESH_INTERVAL = Duration.ofSeconds(60L);
    static final String KAFKA_VERSION_TAG_NAME = "kafka-version";
    static final String CLIENT_ID_TAG_NAME = "client-id";
    static final String DEFAULT_VALUE = "unknown";
    private final Supplier<Map<MetricName, ? extends Metric>> metricsSupplier;
    private final Iterable<Tag> extraTags;
    private final Duration refreshInterval;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private Iterable<Tag> commonTags;
    private volatile Set<MetricName> currentMeters = new HashSet<MetricName>();
    private String kafkaVersion = "unknown";
    private String clientId = "unknown";

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> metricsSupplier) {
        this(metricsSupplier, Collections.emptyList());
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> metricsSupplier, Iterable<Tag> extraTags) {
        this(metricsSupplier, extraTags, DEFAULT_REFRESH_INTERVAL);
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> metricsSupplier, Iterable<Tag> extraTags, Duration refreshInterval) {
        this.metricsSupplier = metricsSupplier;
        this.extraTags = extraTags;
        this.refreshInterval = refreshInterval;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        this.commonTags = this.getCommonTags(registry);
        this.prepareToBindMetrics(registry);
        this.checkAndBindMetrics(registry);
        this.scheduler.scheduleAtFixedRate(() -> this.checkAndBindMetrics(registry), this.getRefreshIntervalInMillis(), this.getRefreshIntervalInMillis(), TimeUnit.MILLISECONDS);
    }

    private Iterable<Tag> getCommonTags(MeterRegistry registry) {
        Meter.Id dummyId = Meter.builder("delete.this", Meter.Type.OTHER, Collections.emptyList()).register(registry).getId();
        registry.remove(dummyId);
        return dummyId.getTags();
    }

    void prepareToBindMetrics(MeterRegistry registry) {
        Map<MetricName, ? extends Metric> metrics = this.metricsSupplier.get();
        Metric startTime = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : metrics.entrySet()) {
            MetricName name = entry.getKey();
            if (this.clientId.equals(DEFAULT_VALUE) && name.tags().get(CLIENT_ID_TAG_NAME) != null) {
                this.clientId = (String)name.tags().get(CLIENT_ID_TAG_NAME);
            }
            if (!METRIC_GROUP_APP_INFO.equals(name.group())) continue;
            if (VERSION_METRIC_NAME.equals(name.name())) {
                this.kafkaVersion = (String)entry.getValue().metricValue();
                continue;
            }
            if (!START_TIME_METRIC_NAME.equals(name.name())) continue;
            startTime = entry.getValue();
        }
        if (startTime != null) {
            this.bindMeter(registry, startTime, this.meterName(startTime), this.meterTags(startTime));
        }
    }

    private long getRefreshIntervalInMillis() {
        return this.refreshInterval.toMillis();
    }

    void checkAndBindMetrics(MeterRegistry registry) {
        Map<MetricName, ? extends Metric> metrics = this.metricsSupplier.get();
        if (!this.currentMeters.equals(metrics.keySet())) {
            this.currentMeters = new HashSet<MetricName>(metrics.keySet());
            metrics.forEach((name, metric) -> {
                Meter other;
                List<Tag> tags;
                if (!(metric.metricValue() instanceof Number)) {
                    return;
                }
                if (METRIC_GROUP_APP_INFO.equals(name.group())) {
                    return;
                }
                if (METRIC_GROUP_METRICS_COUNT.equals(name.group())) {
                    return;
                }
                String meterName = this.meterName((Metric)metric);
                List<Tag> meterTags = this.meterTags((Metric)metric);
                boolean hasLessTags = false;
                Iterator<Meter> iterator = registry.find(meterName).meters().iterator();
                while (iterator.hasNext() && !this.differentClient(tags = (other = iterator.next()).getId().getTags())) {
                    if (tags.size() < meterTags.size()) {
                        registry.remove(other);
                        continue;
                    }
                    if (tags.size() == meterTags.size()) {
                        if (!tags.equals(meterTags)) break;
                        return;
                    }
                    hasLessTags = true;
                }
                if (hasLessTags) {
                    return;
                }
                this.bindMeter(registry, (Metric)metric, meterName, (Iterable<Tag>)meterTags);
            });
        }
    }

    private boolean differentClient(List<Tag> tags) {
        boolean anotherClient = false;
        for (Tag tag : tags) {
            if (!tag.getKey().equals(CLIENT_ID_TAG_NAME) || this.clientId.equals(tag.getValue())) continue;
            anotherClient = true;
        }
        return anotherClient;
    }

    private void bindMeter(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        if (name.endsWith("total") || name.endsWith("count")) {
            this.registerCounter(registry, metric, name, tags);
        } else {
            this.registerGauge(registry, metric, name, tags);
        }
    }

    private void registerGauge(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        Gauge.builder(name, metric, this.toMetricValue()).tags(tags).description(metric.metricName().description()).register(registry);
    }

    private void registerCounter(MeterRegistry registry, Metric metric, String name, Iterable<Tag> tags) {
        FunctionCounter.builder(name, metric, this.toMetricValue()).tags(tags).description(metric.metricName().description()).register(registry);
    }

    private ToDoubleFunction<Metric> toMetricValue() {
        return metric -> ((Number)metric.metricValue()).doubleValue();
    }

    private List<Tag> meterTags(Metric metric) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        metric.metricName().tags().forEach((key, value) -> tags.add(Tag.of(key, value)));
        tags.add(Tag.of(KAFKA_VERSION_TAG_NAME, this.kafkaVersion));
        this.extraTags.forEach(tags::add);
        this.commonTags.forEach(tags::add);
        return tags;
    }

    private String meterName(Metric metric) {
        String name = METRIC_NAME_PREFIX + metric.metricName().group() + "." + metric.metricName().name();
        return name.replaceAll("-metrics", "").replaceAll("-", ".");
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
    }
}

