/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.binder.http.HttpMethods;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.OpenTelemetryApacheHttpClientObservationDocumentation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.jspecify.annotations.Nullable;

@Deprecated
public class OpenTelemetryApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final OpenTelemetryApacheHttpClientObservationConvention INSTANCE = new OpenTelemetryApacheHttpClientObservationConvention();
    private static final KeyValue METHOD_OTHER = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue("_OTHER");
    private static final KeyValue URL_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.HighCardinalityKeyNames.URL.withValue("UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.STATUS.withValue("0");
    private static final KeyValue EXCEPTION_NONE = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.ERROR_TYPE.withNoneValue();
    private static final KeyValue OUTCOME_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.OUTCOME.withValue(Outcome.UNKNOWN.name());
    private static final KeyValue SERVER_ADDRESS_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue("UNKNOWN");
    private static final KeyValue SERVER_PORT_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue("-1");

    protected OpenTelemetryApacheHttpClientObservationConvention() {
    }

    public String getName() {
        return "http.client.request.duration";
    }

    public String getContextualName(ApacheHttpClientContext context) {
        HttpRequest carrier = (HttpRequest)context.getCarrier();
        if (carrier == null) {
            return "HTTP";
        }
        String maybeMethod = this.maybeGetKnownMethod(carrier);
        return maybeMethod == null ? "HTTP" : maybeMethod;
    }

    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), this.method(context), this.status(context), this.outcome(context), this.serverAddress(context), this.serverPort(context)});
    }

    public KeyValues getHighCardinalityKeyValues(ApacheHttpClientContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.urlFull(context)});
    }

    protected @Nullable String maybeGetKnownMethod(HttpRequest request) {
        String httpMethod = request.getMethod();
        if (HttpMethods.isStandard(httpMethod)) {
            return httpMethod;
        }
        return null;
    }

    protected KeyValue method(ApacheHttpClientContext context) {
        String method;
        HttpRequest request = (HttpRequest)context.getCarrier();
        if (request != null && (method = this.maybeGetKnownMethod(request)) != null) {
            return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue(method);
        }
        return METHOD_OTHER;
    }

    protected KeyValue serverAddress(ApacheHttpClientContext context) {
        String serverAddressValue = this.getServerAddressValue(context);
        return serverAddressValue != null ? OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue(serverAddressValue) : SERVER_ADDRESS_UNKNOWN;
    }

    private @Nullable String getServerAddressValue(ApacheHttpClientContext context) {
        RouteInfo httpRoute = OpenTelemetryApacheHttpClientObservationConvention.getHttpRoute(context);
        if (httpRoute != null) {
            return httpRoute.getTargetHost().getHostName();
        }
        URI uri = OpenTelemetryApacheHttpClientObservationConvention.getUri(context);
        if (uri != null && uri.getHost() != null) {
            return uri.getHost();
        }
        return null;
    }

    protected KeyValue serverPort(ApacheHttpClientContext context) {
        Integer serverPortValue = this.getServerPortValue(context);
        return serverPortValue != null ? OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue(String.valueOf(serverPortValue)) : SERVER_PORT_UNKNOWN;
    }

    private @Nullable Integer getServerPortValue(ApacheHttpClientContext context) {
        RouteInfo httpRoute = OpenTelemetryApacheHttpClientObservationConvention.getHttpRoute(context);
        if (httpRoute != null) {
            return httpRoute.getTargetHost().getPort();
        }
        URI uri = OpenTelemetryApacheHttpClientObservationConvention.getUri(context);
        if (uri != null && uri.getPort() != -1) {
            return uri.getPort();
        }
        return null;
    }

    protected KeyValue exception(ApacheHttpClientContext context) {
        Throwable error = context.getError();
        if (error != null) {
            return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.ERROR_TYPE.withValue(error.getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue status(ApacheHttpClientContext context) {
        Throwable error = context.getError();
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return STATUS_UNKNOWN;
        }
        HttpResponse response = (HttpResponse)context.getResponse();
        if (response == null) {
            return STATUS_UNKNOWN;
        }
        return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.STATUS.withValue(String.valueOf(response.getCode()));
    }

    protected KeyValue outcome(ApacheHttpClientContext context) {
        HttpResponse response = (HttpResponse)context.getResponse();
        if (response == null) {
            return OUTCOME_UNKNOWN;
        }
        return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.OUTCOME.withValue(Outcome.forStatus(response.getCode()).name());
    }

    protected KeyValue urlFull(ApacheHttpClientContext context) {
        URI uri;
        HttpRequest request = (HttpRequest)context.getCarrier();
        if (request != null && (uri = OpenTelemetryApacheHttpClientObservationConvention.getUri(context)) != null) {
            return OpenTelemetryApacheHttpClientObservationDocumentation.HighCardinalityKeyNames.URL.withValue(uri.toString());
        }
        return URL_UNKNOWN;
    }

    private static @Nullable URI getUri(ApacheHttpClientContext context) {
        HttpRequest request = (HttpRequest)context.getCarrier();
        if (request != null) {
            try {
                return request.getUri();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static @Nullable RouteInfo getHttpRoute(ApacheHttpClientContext context) {
        return context.getHttpClientContext().getHttpRoute();
    }
}

