/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Marker;

class MetricsTurboFilter
extends TurboFilter {
    private static final String METER_NAME = "logback.events";
    private static final String METER_DESCRIPTION = "Number of log events that were enabled by the effective log level";
    private final LongAdder errorCount = new LongAdder();
    private final LongAdder warnCount = new LongAdder();
    private final LongAdder infoCount = new LongAdder();
    private final LongAdder debugCount = new LongAdder();
    private final LongAdder traceCount = new LongAdder();

    MetricsTurboFilter(MeterRegistry registry, Iterable<Tag> tags) {
        FunctionCounter.builder(METER_NAME, this.errorCount, LongAdder::doubleValue).tags(tags).tags("level", "error").description(METER_DESCRIPTION).baseUnit("events").register(registry);
        FunctionCounter.builder(METER_NAME, this.warnCount, LongAdder::doubleValue).tags(tags).tags("level", "warn").description(METER_DESCRIPTION).baseUnit("events").register(registry);
        FunctionCounter.builder(METER_NAME, this.infoCount, LongAdder::doubleValue).tags(tags).tags("level", "info").description(METER_DESCRIPTION).baseUnit("events").register(registry);
        FunctionCounter.builder(METER_NAME, this.debugCount, LongAdder::doubleValue).tags(tags).tags("level", "debug").description(METER_DESCRIPTION).baseUnit("events").register(registry);
        FunctionCounter.builder(METER_NAME, this.traceCount, LongAdder::doubleValue).tags(tags).tags("level", "trace").description(METER_DESCRIPTION).baseUnit("events").register(registry);
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        if (format == null || !level.isGreaterOrEqual(logger.getEffectiveLevel())) {
            return FilterReply.NEUTRAL;
        }
        this.recordMetrics(level);
        return FilterReply.NEUTRAL;
    }

    private void recordMetrics(Level level) {
        switch (level.toInt()) {
            case 40000: {
                this.errorCount.increment();
                break;
            }
            case 30000: {
                this.warnCount.increment();
                break;
            }
            case 20000: {
                this.infoCount.increment();
                break;
            }
            case 10000: {
                this.debugCount.increment();
                break;
            }
            case 5000: {
                this.traceCount.increment();
            }
        }
    }
}

