/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.okhttp3;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.NonNullApi;
import io.micrometer.common.lang.NonNullFields;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.okhttp3.DefaultOkHttpObservationConvention;
import io.micrometer.core.instrument.binder.okhttp3.LegacyOkHttpMetricsEventListener;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpContext;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpDocumentedObservation;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.http.HttpClientRequest;
import io.micrometer.observation.transport.http.HttpClientResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Request;
import okhttp3.Response;

@NonNullApi
@NonNullFields
public class OkHttpMetricsEventListener
extends EventListener {
    public static final String URI_PATTERN = "URI_PATTERN";
    private final MeterRegistry registry;
    private final ObservationRegistry observationRegistry;
    private final Observation.ObservationConvention<OkHttpContext> observationConvention;
    private final String requestsMetricName;
    private final Function<Request, String> urlMapper;
    private final Iterable<Tag> extraTags;
    private final Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags;
    private final Iterable<Tag> unknownRequestTags;
    private final boolean includeHostTag;
    private final boolean observationRegistryNoOp;
    final ConcurrentMap<Call, CallState> callState = new ConcurrentHashMap<Call, CallState>();
    private final LegacyOkHttpMetricsEventListener legacyListener;
    private final DefaultOkHttpObservationConvention defaultConvention;

    protected OkHttpMetricsEventListener(MeterRegistry registry, String requestsMetricName, Function<Request, String> urlMapper, Iterable<Tag> extraTags, Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags) {
        this(registry, ObservationRegistry.NOOP, new DefaultOkHttpObservationConvention(requestsMetricName), requestsMetricName, urlMapper, extraTags, contextSpecificTags, Collections.emptyList(), true);
    }

    OkHttpMetricsEventListener(MeterRegistry registry, ObservationRegistry observationRegistry, Observation.ObservationConvention<OkHttpContext> observationConvention, String requestsMetricName, Function<Request, String> urlMapper, Iterable<Tag> extraTags, Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags, Iterable<String> requestTagKeys, boolean includeHostTag) {
        this.registry = registry;
        this.observationRegistry = observationRegistry;
        this.observationRegistryNoOp = observationRegistry.isNoop();
        this.observationConvention = observationConvention;
        this.requestsMetricName = requestsMetricName;
        this.urlMapper = urlMapper;
        this.extraTags = extraTags;
        this.contextSpecificTags = contextSpecificTags;
        this.includeHostTag = includeHostTag;
        ArrayList<Tag> unknownRequestTags = new ArrayList<Tag>();
        for (String requestTagKey : requestTagKeys) {
            unknownRequestTags.add(Tag.of(requestTagKey, "UNKNOWN"));
        }
        this.unknownRequestTags = unknownRequestTags;
        this.legacyListener = new LegacyOkHttpMetricsEventListener(registry, requestsMetricName, urlMapper, extraTags, contextSpecificTags, unknownRequestTags, includeHostTag);
        this.defaultConvention = new DefaultOkHttpObservationConvention(requestsMetricName);
    }

    public static Builder builder(MeterRegistry registry, String name) {
        return new Builder(registry, name);
    }

    public void callStart(Call call) {
        final CallState callState = new CallState(this.registry.config().clock().monotonicTime(), call.request());
        OkHttpContext okHttpContext = new OkHttpContext(callState, this.urlMapper, this.extraTags, this.contextSpecificTags, this.unknownRequestTags, this.includeHostTag);
        if (callState.request != null) {
            okHttpContext.setRequest(new HttpClientRequest(){
                Set<KeyValue> headers;
                {
                    this.headers = StreamSupport.stream(callState.request.headers().spliterator(), false).map(pair -> KeyValue.of((String)((String)pair.getFirst()), (String)((String)pair.getSecond()))).collect(Collectors.toCollection(HashSet::new));
                }

                public void header(String name, String value) {
                    this.headers.add(KeyValue.of((String)name, (String)value));
                }

                public String method() {
                    return callState.request.method();
                }

                public String path() {
                    return (String)callState.request.url().pathSegments().get(0);
                }

                public String url() {
                    return callState.request.url().toString();
                }

                public String header(String name) {
                    return this.headers.stream().filter(keyValue -> keyValue.getKey().equals(name)).findFirst().map(KeyValue::getValue).orElse(null);
                }

                public Collection<String> headerNames() {
                    return this.headers.stream().map(KeyValue::getKey).collect(Collectors.toList());
                }

                public Object unwrap() {
                    return callState.request;
                }
            });
        }
        Observation observation = OkHttpDocumentedObservation.DEFAULT.start(this.observationConvention, this.defaultConvention, (Observation.Context)okHttpContext, this.observationRegistry);
        callState.setContext(okHttpContext);
        callState.setObservation(observation);
        this.callState.put(call, callState);
    }

    public void callFailed(Call call, IOException e) {
        CallState state = (CallState)this.callState.remove(call);
        if (state != null) {
            state.exception = e;
            this.time(state);
        }
    }

    public void callEnd(Call call) {
        this.callState.remove(call);
    }

    public void responseHeadersEnd(Call call, Response response) {
        CallState state = (CallState)this.callState.remove(call);
        if (state != null) {
            state.response = response;
            this.time(state);
        }
    }

    void time(final CallState state) {
        OkHttpContext okHttpContext = state.context;
        if (this.observationRegistryNoOp) {
            this.legacyListener.time(state);
        } else {
            state.observation.error((Throwable)state.exception);
            if (state.response != null) {
                okHttpContext.setResponse(new HttpClientResponse(){

                    public int statusCode() {
                        return state.response.code();
                    }

                    public Collection<String> headerNames() {
                        return state.response.headers().names();
                    }

                    public Object unwrap() {
                        return state.response;
                    }
                });
            }
            state.observation.stop();
        }
    }

    public static class Builder {
        private final MeterRegistry registry;
        private final String name;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private Function<Request, String> uriMapper = request -> Optional.ofNullable(request.header(OkHttpMetricsEventListener.URI_PATTERN)).orElse("none");
        private Tags tags = Tags.empty();
        private Collection<BiFunction<Request, Response, Tag>> contextSpecificTags = new ArrayList<BiFunction<Request, Response, Tag>>();
        private boolean includeHostTag = true;
        private Iterable<String> requestTagKeys = Collections.emptyList();
        private OkHttpObservationConvention observationConvention;

        Builder(MeterRegistry registry, String name) {
            this.registry = registry;
            this.name = name;
        }

        public Builder tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public Builder observationConvention(OkHttpObservationConvention observationConvention) {
            this.observationConvention = observationConvention;
            return this;
        }

        public Builder tag(Tag tag) {
            this.tags = this.tags.and(tag);
            return this;
        }

        public Builder tag(BiFunction<Request, Response, Tag> contextSpecificTag) {
            this.contextSpecificTags.add(contextSpecificTag);
            return this;
        }

        public Builder uriMapper(Function<Request, String> uriMapper) {
            this.uriMapper = uriMapper;
            return this;
        }

        public Builder includeHostTag(boolean includeHostTag) {
            this.includeHostTag = includeHostTag;
            return this;
        }

        public Builder requestTagKeys(String ... requestTagKeys) {
            return this.requestTagKeys(Arrays.asList(requestTagKeys));
        }

        public Builder requestTagKeys(Iterable<String> requestTagKeys) {
            this.requestTagKeys = requestTagKeys;
            return this;
        }

        public OkHttpMetricsEventListener build() {
            return new OkHttpMetricsEventListener(this.registry, this.observationRegistry, this.observationConvention, this.name, this.uriMapper, this.tags, this.contextSpecificTags, this.requestTagKeys, this.includeHostTag);
        }
    }

    static class CallState {
        final long startTime;
        Observation observation;
        @Nullable
        final Request request;
        OkHttpContext context;
        @Nullable
        Response response;
        @Nullable
        IOException exception;

        CallState(long startTime, @Nullable Request request) {
            this.startTime = startTime;
            this.request = request;
        }

        void setContext(OkHttpContext context) {
            this.context = context;
        }

        void setObservation(Observation observation) {
            this.observation = observation;
        }
    }
}

