/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.okhttp3;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.okhttp3.OkHttpMetricsEventListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Request;
import okhttp3.Response;

class LegacyOkHttpMetricsEventListener {
    public static final String URI_PATTERN = "URI_PATTERN";
    private static final boolean REQUEST_TAG_CLASS_EXISTS = LegacyOkHttpMetricsEventListener.getMethod(Class.class) != null;
    private static final String TAG_TARGET_SCHEME = "target.scheme";
    private static final String TAG_TARGET_HOST = "target.host";
    private static final String TAG_TARGET_PORT = "target.port";
    private static final String TAG_VALUE_UNKNOWN = "UNKNOWN";
    private static final Tags TAGS_TARGET_UNKNOWN = Tags.of("target.scheme", "UNKNOWN", "target.host", "UNKNOWN", "target.port", "UNKNOWN");
    private final MeterRegistry registry;
    private final String requestsMetricName;
    private final Function<Request, String> urlMapper;
    private final Iterable<Tag> extraTags;
    private final Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags;
    private final Iterable<Tag> unknownRequestTags;
    private final boolean includeHostTag;

    LegacyOkHttpMetricsEventListener(MeterRegistry registry, String requestsMetricName, Function<Request, String> urlMapper, Iterable<Tag> extraTags, Iterable<BiFunction<Request, Response, Tag>> contextSpecificTags, Iterable<Tag> unknownRequestTags, boolean includeHostTag) {
        this.registry = registry;
        this.requestsMetricName = requestsMetricName;
        this.urlMapper = urlMapper;
        this.extraTags = extraTags;
        this.contextSpecificTags = contextSpecificTags;
        this.unknownRequestTags = unknownRequestTags;
        this.includeHostTag = includeHostTag;
    }

    @Nullable
    private static Method getMethod(Class<?> ... parameterTypes) {
        try {
            return Request.class.getMethod("tag", parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    void time(OkHttpMetricsEventListener.CallState state) {
        Request request = state.request;
        boolean requestAvailable = request != null;
        Tags tags = Tags.of("method", requestAvailable ? request.method() : TAG_VALUE_UNKNOWN, "uri", this.getUriTag(state, request), "status", this.getStatusMessage(state.response, state.exception)).and(this.extraTags).and(StreamSupport.stream(this.contextSpecificTags.spliterator(), false).map(contextTag -> (Tag)contextTag.apply(request, state.response)).collect(Collectors.toList())).and(this.getRequestTags(request)).and(this.generateTagsForRoute(request));
        if (this.includeHostTag) {
            tags = Tags.of(tags).and("host", requestAvailable ? request.url().host() : TAG_VALUE_UNKNOWN);
        }
        ((Timer.Builder)Timer.builder(this.requestsMetricName).tags((Iterable)tags)).description("Timer of OkHttp operation").register(this.registry).record(this.registry.config().clock().monotonicTime() - state.startTime, TimeUnit.NANOSECONDS);
    }

    private Tags generateTagsForRoute(@Nullable Request request) {
        if (request == null) {
            return TAGS_TARGET_UNKNOWN;
        }
        return Tags.of(TAG_TARGET_SCHEME, request.url().scheme(), TAG_TARGET_HOST, request.url().host(), TAG_TARGET_PORT, Integer.toString(request.url().port()));
    }

    private String getUriTag(OkHttpMetricsEventListener.CallState state, @Nullable Request request) {
        if (request == null) {
            return TAG_VALUE_UNKNOWN;
        }
        return state.response != null && (state.response.code() == 404 || state.response.code() == 301) ? "NOT_FOUND" : this.urlMapper.apply(request);
    }

    private Iterable<Tag> getRequestTags(@Nullable Request request) {
        Object requestTag;
        if (request == null) {
            return this.unknownRequestTags;
        }
        if (REQUEST_TAG_CLASS_EXISTS && (requestTag = (Tags)request.tag(Tags.class)) != null) {
            return requestTag;
        }
        requestTag = request.tag();
        if (requestTag instanceof Tags) {
            return (Tags)requestTag;
        }
        return Tags.empty();
    }

    private String getStatusMessage(@Nullable Response response, @Nullable IOException exception) {
        if (exception != null) {
            return "IO_ERROR";
        }
        if (response == null) {
            return "CLIENT_ERROR";
        }
        return Integer.toString(response.code());
    }
}

