/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.context;

import io.micrometer.context.ContextAccessor;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ThreadLocalAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

final class DefaultContextSnapshot
extends HashMap<Object, Object>
implements ContextSnapshot {
    private final ContextRegistry contextRegistry;
    private final boolean clearMissing;

    DefaultContextSnapshot(ContextRegistry contextRegistry, boolean clearMissing) {
        this.contextRegistry = contextRegistry;
        this.clearMissing = clearMissing;
    }

    @Override
    public <C> C updateContext(C context) {
        return this.updateContextInternal(context, this);
    }

    @Override
    public <C> C updateContext(C context, Predicate<Object> keyPredicate) {
        if (!this.isEmpty()) {
            HashMap<Object, Object> valuesToWrite = new HashMap<Object, Object>();
            this.forEach((key, value) -> {
                if (keyPredicate.test(key)) {
                    valuesToWrite.put(key, value);
                }
            });
            context = this.updateContextInternal(context, valuesToWrite);
        }
        return context;
    }

    private <C> C updateContextInternal(C context, Map<Object, Object> valueContainer) {
        if (!this.isEmpty()) {
            ContextAccessor<?, ?> accessor = this.contextRegistry.getContextAccessorForWrite(context);
            context = accessor.writeValues(valueContainer, context);
        }
        return context;
    }

    @Override
    public ContextSnapshot.Scope setThreadLocals() {
        return this.setThreadLocals(key -> true);
    }

    @Override
    public ContextSnapshot.Scope setThreadLocals(Predicate<Object> keyPredicate) {
        Map<Object, Object> previousValues = null;
        List<ThreadLocalAccessor<?>> accessors = this.contextRegistry.getThreadLocalAccessors();
        for (int i = 0; i < accessors.size(); ++i) {
            ThreadLocalAccessor<?> accessor = accessors.get(i);
            Object key = accessor.key();
            if (!keyPredicate.test(key)) continue;
            if (this.containsKey(key)) {
                Object value = this.get(key);
                assert (value != null) : "snapshot contains disallowed null mapping for key: " + key;
                previousValues = DefaultContextSnapshot.setThreadLocal(key, value, accessor, previousValues);
                continue;
            }
            if (!this.clearMissing) continue;
            previousValues = DefaultContextSnapshot.clearThreadLocal(key, accessor, previousValues);
        }
        return DefaultScope.from(previousValues, this.contextRegistry);
    }

    static <V> Map<Object, Object> setThreadLocal(Object key, V value, ThreadLocalAccessor<?> accessor, @Nullable Map<Object, Object> previousValues) {
        previousValues = previousValues != null ? previousValues : new HashMap<Object, Object>();
        previousValues.put(key, accessor.getValue());
        accessor.setValue(value);
        return previousValues;
    }

    static Map<Object, Object> clearThreadLocal(Object key, ThreadLocalAccessor<?> accessor, @Nullable Map<Object, Object> previousValues) {
        previousValues = previousValues != null ? previousValues : new HashMap<Object, Object>();
        previousValues.put(key, accessor.getValue());
        accessor.setValue();
        return previousValues;
    }

    @Override
    public String toString() {
        return "DefaultContextSnapshot" + super.toString();
    }

    static class DefaultScope
    implements ContextSnapshot.Scope {
        private final Map<Object, Object> previousValues;
        private final ContextRegistry contextRegistry;

        private DefaultScope(Map<Object, Object> previousValues, ContextRegistry contextRegistry) {
            this.previousValues = previousValues;
            this.contextRegistry = contextRegistry;
        }

        @Override
        public void close() {
            List<ThreadLocalAccessor<?>> accessors = this.contextRegistry.getThreadLocalAccessors();
            for (int i = accessors.size() - 1; i >= 0; --i) {
                ThreadLocalAccessor<?> accessor = accessors.get(i);
                if (!this.previousValues.containsKey(accessor.key())) continue;
                Object previousValue = this.previousValues.get(accessor.key());
                this.resetThreadLocalValue(accessor, previousValue);
            }
        }

        private <V> void resetThreadLocalValue(ThreadLocalAccessor<?> accessor, @Nullable V previousValue) {
            if (previousValue != null) {
                accessor.restore(previousValue);
            } else {
                accessor.restore();
            }
        }

        public static ContextSnapshot.Scope from(@Nullable Map<Object, Object> previousValues, ContextRegistry registry) {
            return previousValues != null ? new DefaultScope(previousValues, registry) : () -> {};
        }
    }
}

